/*global window, document, BEM*/

(function(w, d, n, s, t) {
    /*jshint strict:false*/
    w[n] = w[n] || [];
    t = d.documentElement.firstChild;
    s = d.createElement('script');
    s.type = 'text/javascript';
    s.src = '//an.yandex.ru/system/context.js';
    s.setAttribute('async', 'true');
    t.insertBefore(s, t.firstChild);
})(window, document, 'yandex_context_callbacks');

(function (window, BEM, extend) {

    'use strict';

    var loaded = false,
        callbacks = [];

    function onLoad(callback) {
        if (loaded) {
            callback();
        } else {
            callbacks.push(callback);
        }
    }

    function execOnLoad() {
        loaded = true;

        callbacks.forEach(function(callback) {
            callback();
        });

        callbacks = null;
    }

    window.yandex_context_callbacks.push(execOnLoad);

    /**
     * Интерфейс к клиентскому коду
     */

    BEM.DOM.decl('i-pcode', {}, {
        /**
         * @param {function} callback
         */
        onLoad: onLoad,

        /**
         * @param {string} elementId id элемента, в котором необходимо отрендерить объявления
         * @param {object} settings конфигурация блока (цвета/рамки)
         * @param {object} data данные объявлений
         */
        render: function (elementId, settings, data, blockId) {
            if (!loaded) {
                onLoad(this.render.bind(this, elementId, settings, data, blockId));
                return;
            }

            if (data && window.Ya) {
                if (data.rtb && window.Ya.Context) {
                    window.Ya.Context.AdvManager.render({
                        async: true,
                        renderTo: elementId,
                        data: data,
                        blockId: blockId
                    });
                } else if ((data.direct || data.premium) && window.Ya.Direct) {
                    settings = extend({}, settings); // clone
                    settings.ad_format = data.direct ? 'direct' : 'premium';
                    settings.data = data;
                    window.Ya.Direct.insertInto(53618, elementId, settings);
                }
            }
        }
    });

})(window, BEM, jQuery.extend);
