package RestApi::BaseModel;

use qbit;

use Utils::PublicID;

sub api_available_fields {
    my ($self) = @_;
    my $fields = $self->get_model_fields();
    my %keys = map {$fields->{$_}{'api'} ? ($_ => undef) : ()} keys(%$fields);

    if (exists($keys{'login'}) && $self->accessor ne 'users') {
        my $allow_login = $self->check_short_rights('view_field__login');

        delete($keys{'login'})
          unless $allow_login;
    }

    return sort keys(%keys);
}

sub api_check_public_id {
    return check_public_id($_[1], 'simple_id');
}

sub api_noneditable_fields {
    my ($self) = @_;
    my $fields = $self->get_model_fields();

    return map {exists $fields->{$_}{'api_can_edit'} && !$fields->{$_}{'api_can_edit'} ? ($_ => 1) : ()} keys(%$fields);
}

TRUE;
