package RestApi::Controller::API::Brands;

use Mojo::Base qw(RestApi::Controller::API);

use qbit;

sub get_brand_suggest {
    my ($self, %opts) = @_;

    QBit::Validator->new(
        data     => \%opts,
        template => {
            type   => 'hash',
            fields => {
                block_id  => {type => 'scalar', optional => 1},
                substring => {type => 'scalar'},
                limit     => {type => 'int_un'},
            },
        },
        throw => TRUE
    );

    my $result = $self->models->tns_dict_brand->get_brand_suggest(%opts);

    return map {$_->{'bid'} .= ''; $_} @$result;
}

TRUE;
