package RestApi::Controller::API::CommonOffer;

use base qw(RestApi::Controller::API);
use Exception::CommonOffer;
use Exception::Denied;
use qbit;

sub offer_get {
    my ($self, %opts) = @_;

    return $self->models->common_offer->offer_get(%opts);
}

sub offer_accept {
    my ($self, %opts) = @_;

    my $result;
    try {
        $result = $self->models->common_offer->offer_accept(%opts);
    }
    catch Exception::CommonOffer with {
        my ($exception) = @_;

        throw Exception::Denied $exception;
    };

    return $result;
}

sub offer_text {
    my ($self, %opts) = @_;

    return $self->models->common_offer->offer_text(%opts);
}

sub offer_check {
    my ($self, %opts) = @_;

    my %data;
    try {
        $data{success} = $self->models->users->check_pi_adfox_contracts(
            allow_paid_services => $opts{adfox_offer},
            from_offer          => 1,
            user_id             => $self->models->get_option('cur_user', {})->{id},
            %opts,
        ) ? 1 : 0;
    }
    catch Exception::CommonOffer with {
        my ($exception) = @_;

        %data = (
            error_message => $exception->{text},
            error_token   => $exception->{error_token},
            success       => 0,
        );

        $self->models->exception_dumper->dump_as_html_file($exception);
    };

    return \%data;
}

1;
