package RestApi::Controller::API::Frontend;

use qbit;

use base qw(RestApi::Controller::API);

use MenuHierarchy qw(get_menu);
use PiConstants qw($TVM_HTTP_HEADER_NAME);
use Rosetta::Methods qw(nacked_call);

sub model_accessor { }

my %hh_available_resources;

sub get_menu_tree {
    my ($self, %opts) = @_;

    my $menu = get_menu($self->models);

    my @available_resources_list =
      grep {1 == ${$_->{show_in_menu}}} @{$self->models->resources->get_available_resources()};
    %hh_available_resources = map {$_->{resource} => $_} @available_resources_list;

    my $cur_user_id = $self->models->get_option('cur_user', {})->{id};
    my $cur_user = $self->models->users->get($cur_user_id, fields => ['features']);
    my $features;
    if (defined($cur_user)) {
        $features = $cur_user->{features} // [];
    } else {
        $features = [];
    }
    my %feature_list = map {$_ => 1} @{$features};

    my $node_id = 0;
    my @menu_processed;
    foreach my $node (@$menu) {
        my $node_proccessed = _traverse_menu_tree($node, \$node_id);
        if (0 < $node_proccessed->{nodes_available_from_here}) {
            my $t = _traverse_menu_tree_remover($node_proccessed, \%feature_list);
            # checking availability again for the group header,
            # bc we should not show unavailble group header even if there are available children
            if ($t && ('item' eq $t->{type} || (@{$t->{children}} && _is_resource_available($t->{resource})))) {
                _fix_url($t);
                push @menu_processed, $t;
            }
        }
    }

    return @menu_processed;
}

# Проставляет родителю урл первого доступного ребёнка
# Если таковых нет - оставляет тот, который был
sub _fix_url {
    my ($node) = @_;

    if (scalar @{$node->{children}}) {
        _fix_url($_) foreach (@{$node->{children}});
        $node->{url} = $node->{children}[0]{url};
    }
}

sub _is_resource_available {
    my ($resource) = @_;
    # for group and subgroup headers resource=undef
    return 1 unless $resource;
    if (exists $hh_available_resources{$resource}) {
        # no GET in methods means user can only POST/PATCH = add/edit thru API
        if (in_array('GET', $hh_available_resources{$resource}->{methods})) {
            return 1;
        } else {
            return 0;
        }
    } else {
        return 0;
    }
}

sub _traverse_menu_tree_remover {
    my ($node, $feature_list) = @_;

    my $should_remove = 0;
    my $only_with_features =
        exists $node->{only_with_feature}
      ? '' eq ref $node->{only_with_feature}
          ? [$node->{only_with_feature}]
          : $node->{only_with_feature}
      : [];
    my $only_no_features =
        exists $node->{only_no_feature}
      ? '' eq ref $node->{only_no_feature}
          ? [$node->{only_no_feature}]
          : $node->{only_no_feature}
      : [];

    if (@$only_with_features && scalar grep {!exists $feature_list->{$_}} @$only_with_features) {
        $should_remove = 1;
    }
    if (@$only_no_features && scalar grep {exists $feature_list->{$_}} @$only_no_features) {
        $should_remove = 1;
    }
    if (0 == $node->{nodes_available_from_here}) {
        $should_remove = 1;
    }

    if ($should_remove) {
        unless (exists $node->{_parent}->{type}) {
            return undef;
        }
        if (@{$node->{_parent}->{children}} > 1) {
            $node->{_parent}->{children} = _without($node->{_parent}->{children}, $node);
        } else {
            $node->{_parent}->{children} = [];
            my $p = $node->{_parent};
            while (exists $p->{type}) {    # we have reached fake root node
                if (0 == @{$p->{children}} && 'item' ne $p->{type}) {
                    $p->{_parent}->{children} = _without($p->{_parent}->{children}, $p);
                }
                $p = $p->{_parent};
            }
        }
    } else {
        foreach my $node_x (@{$node->{children}}) {
            _traverse_menu_tree_remover($node_x, $feature_list);
        }
    }

    delete $node->{nodes_available_from_here};    # this can stay
    delete $node->{_parent};                      # this can not; no circular links in json
    delete $node->{_id};
    delete $node->{$_} for (qw(only_with_feature only_no_feature));

    return $node;
}

sub _traverse_menu_tree {
    my ($node, $node_id) = @_;

    $node->{_id} = $$node_id++;

    $node->{nodes_available_from_here} = 0 unless exists $node->{nodes_available_from_here};

    # do not touch adfox menu
    unless ('partner' eq $node->{origin}) {
        $node->{nodes_available_from_here} = 1;
        return $node;
    }

    $node->{nodes_available_from_here} += _is_resource_available($node->{resource});

    foreach my $node_x (@{$node->{children}}) {
        $node_x->{_parent} = $node;
        if (_is_resource_available($node_x->{resource})) {
            my $p = $node_x;
            while ($p = $p->{_parent}) {
                $p->{nodes_available_from_here}++;
            }
        }
        _traverse_menu_tree($node_x, $node_id);
    }

    return $node;
}

sub _without {
    my ($node_list, $node) = @_;

    #_id не существует если мы ещё не просматривали эти элементы
    #но при этом удаление может быть только просмотренного элемента
    return [grep {!defined($_->{_id}) || $node->{_id} != $_->{_id}} @$node_list];
}

sub rosetta {
    my ($self, %opts) = @_;

    my $app = $self->models;
    my $ticket = $self->req->headers->header($TVM_HTTP_HEADER_NAME) // '';
    my $tvm_app;
    if (my $result = $app->api_tvm->check_ticket($ticket)) {
        $tvm_app = $result->{src};
    }

    throw Exception::Denied gettext('TVM check failed')
      if (!$tvm_app || $tvm_app ne $self->models->get_option('tvm_app_pi2_frontend', ''));

    $self->check_data_keys(
        \%opts,
        {
            args             => 1,
            method           => 1,
            model            => 1,
            nginx_request_id => 0,
            request_id       => 0,
        }
    );

    my $res = nacked_call($app, %opts);

    return @$res;
}

sub find_blocks {
    my ($self, %opts) = @_;

    my $text = $self->param('text') // '';

    return $self->models->frontend->find_blocks($text);
}

1;
