package RestApi::Controller::API::Maps;

use Mojo::Base qw(RestApi::Controller::API);

use qbit;

use Exception::Validation::BadArguments;
use Exception::Validator::Errors;

sub get_companies_by_ll {
    my ($self, %opts) = @_;

    $self->check_data_keys(\%opts, {ll => 1});

    QBit::Validator->new(
        data     => \%opts,
        template => {
            type   => 'hash',
            fields => {ll => {type => 'gps'},},
        },
        throw => TRUE
    );

    my $result = $self->models->api_http_maps->get_companies_by_ll($opts{ll});

    return @$result;
}

TRUE;
