package RestApi::Controller::API::Payoneer;

use qbit;

use base qw(RestApi::Controller::API);

sub check_currency {
    my ($self, %opts) = @_;

    # Проверка доступных параметров
    $self->check_data_keys(\%opts, {force => 0,});

    return $self->models->users->payoneer_check_currency(%opts);
}

sub set_currency {
    my ($self, %opts) = @_;

    # Проверка доступных параметров
    $self->check_data_keys(
        \%opts,
        {
            currency => 1,
            force    => 0,
        }
    );

    return $self->models->users->payoneer_set_currency(%opts);
}

sub get_login_link {
    my ($self, %opts) = @_;

    # Проверка доступных параметров
    $self->check_data_keys(\%opts, {force => 0,});

    return $self->models->users->payoneer_get_login_link(%opts);
}

sub check_payee_status {
    my ($self, %opts) = @_;

    # Проверка доступных параметров
    $self->check_data_keys(\%opts, {});

    return $self->models->users->payoneer_check_payee_status(%opts);
}

1;
