package RestApi::Controller::API::Statistics;

use base qw(RestApi::Controller::API);
use PiConstants qw( $MOL_REPORT_TYPE_MAIN $MOL_REPORT_TYPE_DSP $MOL_REPORT_TYPE_MM %MOL_STAT_TYPES);

use qbit;

sub model_accessor { }

sub get_tree {
    my ($self, %opts) = @_;

    $opts{stat_type} = $self->param('stat_type');

    my $data = $self->models->bk_statistics->get_tree2(%opts);

    # cast numbers for bionic (PI-25984)
    my $tree = $data->{'tree'};
    if ($tree && @$tree && $tree->[0]->{entity_filter_fields} && $tree->[0]->{entity_filter_fields}->{region_id}) {
        foreach my $el (@{$tree->[0]->{entity_filter_fields}->{region_id}->{values}}) {
            $el->{level} .= '';
        }
    }

    return $data;
}

sub get_statistics {
    my ($self, %opts) = @_;

    $opts{stat_type} = $self->param('stat_type');

    return $self->models->bk_statistics->get_statistics2(%opts);
}

sub get_available_report_types {
    my ($self, %opts) = @_;

    my $always = $self->models->check_rights('bk_statistics_always_view');

    my @report_type_list;
    if ($always || $self->models->check_rights('bk_statistics_view')) {
        push @report_type_list, $MOL_REPORT_TYPE_MAIN;
    }
    if ($always
        || ($self->models->users->get($self->models->get_option('cur_user'), fields => [qw(has_mobile_mediation)])
            // {})->{has_mobile_mediation})
    {
        push @report_type_list, $MOL_REPORT_TYPE_MM;
    }
    if ($always || $self->models->check_rights('bk_statistics_view_dsp')) {
        push @report_type_list, $MOL_REPORT_TYPE_DSP;
    }

    return map {{id => $_, label => $MOL_STAT_TYPES{$_}{label}->()}} @report_type_list;
}

TRUE;
