package RestApi::Controller::API::Uploader;

use qbit;

use base qw(RestApi::Controller::API);

use PiConstants qw($INDOOR_PARTNER_ROLE_ID $MAX_CPM);

use Utils::CSV qw(parse_csv_indoor_blocks combine_csv_indoor_blocks parse_csv);

sub model_accessor { }

sub indoor {
    my ($self, %opts) = @_;

    unless ($opts{file_content}) {
        throw Exception::Validation::BadArguments gettext('Expected non empty "file_content"');
    }

    my $csv = $opts{file_content};

    my $parsed;
    try {
        $parsed = parse_csv_indoor_blocks($csv);
    }
    catch {
        my ($ex) = @_;
        throw Exception::Validation::BadArguments('Cant parse CSV: ' . $ex->message());
    };

    my ($login, $articles, $brands, $blocks) =
      ($parsed->{login}, $parsed->{articles} // [], $parsed->{brands} // [], $parsed->{blocks} // []);

    my ($blocks_added, $errors, $articles_not_found, $brands_not_found);
    try {
        ($blocks_added, $errors, $articles_not_found, $brands_not_found) =
          $self->models->indoor_block->add_blocks($login, $articles, $brands, $blocks);
    }
    catch {
        my ($ex) = @_;
        throw Exception::Validation::BadArguments($ex->message());
    };

    return combine_csv_indoor_blocks(
        {
            %$parsed,
            (
                blocks             => $blocks_added,
                errors             => [map {$_ =~ s/[\n\s]+/ /g; $_} map {join(' / ', @{$_})} @$errors],
                articles_not_found => $articles_not_found,
                brands_not_found   => $brands_not_found
            )
        }
    );
}

my $page_tags_types = {
    tags => {
        table => '//home/partner/dict/page_tags',
        key   => ['page_id', 'tags'],
        row   => sub {
            my ($row) = @_;
            return map {{page_id => $row->{page_id} + 0, tags => trim($_), service => $row->{service}}}
              split(/,/, $row->{tags});
          }
    },
    blocks => {
        table => '//home/partner/dict/block_tags',
        key   => ['page_id', 'block_id', 'tags'],
        row   => sub {
            my ($row) = @_;
            return map {{page_id => $row->{page_id} + 0, block_id => $row->{block_id}, tags => trim($_)}}
              split(/,/, $row->{tags});
          }
    },
    logins => {
        table => '//home/partner/dict/inner_login',
        key   => 'login',
        row   => sub {
            my ($row) = @_;
            return +{login => $row->{login}};
          }
    },
    domains => {
        table => '//home/partner/dict/inner_domain',
        key   => 'domain',
        row   => sub {
            my ($row) = @_;
            return +{domain => $row->{domain}};
          }
    },
    tags_groups => {
        table => '//home/partner/dict/tag_groups',
        key   => 'tag',
        row   => sub {
            my ($row) = @_;
            return +{
                tag         => $row->{tag},
                tag_group   => $row->{tag_group},
                description => $row->{description} // '',
            };
          }
    },
};

sub page_tags {
    my ($self, %opts) = @_;

    unless ($opts{file_content}) {
        throw Exception::Validation::BadArguments gettext('Expected non empty "file_content"');
    }

    my $type = $opts{type};
    unless ($type and exists $page_tags_types->{$type}) {
        throw Exception::Validation::BadArguments gettext('Expected valid type');
    }

    my $parsed;
    try {
        my $data = $opts{file_content};
        $data =~ s/\r?\n/\n/g;
        my $sc = $data =~ /\t/ ? "\t" : ';';
        $parsed = parse_csv($data, sep_char => $sc);
    }
    catch {
        my ($ex) = @_;
        throw Exception::Validation::BadArguments('Cant parse CSV: ' . $ex->message());
    };

    my $sub = $page_tags_types->{$type}{row};
    my @list;
    for my $row (@$parsed) {
        push @list, $sub->($row);
    }
    my $data;
    if ($opts{is_delete}) {
        my $key = $page_tags_types->{$type}{key};
        $key = [$key] unless ref $key;
        for my $row (@list) {
            my %row;
            @row{@$key} = @{$row}{@$key};
            push @$data, \%row;
        }
    } else {
        $data = \@list;
    }

    my $r = $self->models->api_yt->insert_rows(
        path                 => $page_tags_types->{$type}{table},
        data                 => $data,
        require_sync_replica => FALSE,
        is_delete            => $opts{is_delete},
        params               => {
            ':timeout'  => 60,
            ':attempts' => 3,
            ':delay'    => 0,
        }
    );

    return $r;
}

1;
