package RestApi::Controller::SimpleModel;

use Mojo::Base qw(RestApi::Controller);

use RestApi::Errors;

use Exception::NotFound;

use qbit;

use Exception::IncorrectParams;

sub resource {
    my ($self) = @_;

    my $resource = $self->param('resource');

    my ($error, $exception, $result);
    try {
        my $all = $self->models->$resource->api_get_all($self, $resource, FALSE);

        $result = {
            data => $all,
            meta => {
                count  => scalar(@$all),
                fields => [$self->get_fields($resource)],
            },
            links => {self => $self->get_current_url()}
        };
    }
    catch Exception::IncorrectParams with {
        $error     = ERROR__PARAMS;
        $exception = shift->message();
    }
    catch {
        $error     = ERROR__INTERNAL;
        $exception = $self->safe_exception_message(shift);
    };

    return $self->render($self->get_error($error, $exception))
      if defined($error);

    return $self->render(json => $result);
}

sub resource_get {
    my ($self) = @_;

    my $resource = $self->param('resource');
    my %opts;
    if ($self->models->$resource->can('get_allowed_params')) {
        %opts = map {$_ => $self->param($_)} $self->models->$resource->get_allowed_params();
    }

    my ($error, $exception, $result);

    try {
        my $data = $self->models->$resource->api_get($self, $self->param('public_id'), $resource, %opts);

        throw Exception::NotFound unless defined($data);

        $result = {
            data  => $data,
            meta  => {fields => [$self->get_fields($resource)]},
            links => {self => $self->get_current_url()}
        };
    }
    catch Exception::IncorrectParams with {
        $error     = ERROR__PARAMS;
        $exception = shift->message();
    }
    catch Exception::Conflict with {
        $error     = ERROR__CONFLICT;
        $exception = shift->message();
    }
    catch Exception::NotFound with {
        $error = ERROR__NOT_FOUND;
    }
    catch {
        $error     = ERROR__INTERNAL;
        $exception = $self->safe_exception_message(shift);
    };

    return $self->render($self->get_error($error, $exception))
      if defined($error);

    return $self->render(json => $result);
}

1;
