package RestApi::DBModel;

use qbit;

use base qw(Exporter RestApi::BaseModel);

use RestApi::Relationships;
use Utils::PublicID;

use Exception::Validation::BadArguments;

sub api_can_delete {FALSE}

sub api_can_edit {FALSE}

sub api_can_add {FALSE}

# must return public_id
sub api_add {
    my ($self, %attributes) = @_;
    return $self->add(%attributes);
}

sub api_edit {
    my ($self, $public_id, %attributes) = @_;
    return $self->edit($public_id, %attributes);
}

sub api_delete {
    my ($self, $filter) = @_;

    return $self->delete($filter);
}

sub api_get {
    my ($self, $pk, %opts) = @_;

    # по хорошему нужно сделать в каждой модели фильтр по первичному ключу (publicid) с одинаковым именем,
    # чтобы не заниматься опеределение на ходу
    # TODO проверить, возможно, не будет работать для SSP, где есть хак с public_id:
    # https://github.yandex-team.ru/partner/partner2/blob/c4520b4c39d25d9876731ff4fb811fc85c7bd380/lib/Application/Model/SSP.pm#L533
    my $filters = $self->get_model_filter_fields() // {};
    my $pk_name = (grep {$filters->{$_}{'type'} && $filters->{$_}{'type'} eq 'publicid'} keys(%$filters))[0]
      // $self->get_pk_fields()->[0];

    return $self->api_get_all(%opts, filter => {$pk_name => $pk})->[0];
}

sub api_get_meta {
    my ($self) = @_;

    my $fields_by_right = {
        can_view_other => 'view_field__login',
        can_edit_other => 'add_other'
    };

    return {
        (
            $self->DOES('Application::Model::Role::Has::Block::DesignTemplates')
              && $self->check_short_rights('can_validate_design_as_manager')
            ? (can_validate_design_as_manager => \1)
            : ()
        ),
        map {$_ => \1}
          grep {$self->check_short_rights($fields_by_right->{$_})}
          sort keys %$fields_by_right
    };
}

sub api_get_all {
    my ($self, %opts) = @_;

    my %available_fields = map {$_ => TRUE} $self->get_all_available_fields();

    my @bad_fields           = ();
    my $has_editable_fields  = FALSE;
    my $has_available_fields = FALSE;
    foreach (grep {$_ ne 'public_id'} @{$opts{'fields'}}) {
        push(@bad_fields, $_) unless $available_fields{$_};

        if ($_ eq 'editable_fields') {
            $has_editable_fields = TRUE;
        } elsif ($_ eq 'available_fields') {
            $has_available_fields = TRUE;
        }
    }

    throw Exception::Validation::BadArguments gettext('Unexpected fields: %s', join(', ', @bad_fields)) if @bad_fields;

    push(@{$opts{'fields'}}, 'available_fields') unless $has_available_fields;

    my $data = $self->get_all(%opts);

    delete($self->{'__LAST_FIELDS__'}{'available_fields'}) unless $has_available_fields;

    if ($has_editable_fields || $has_available_fields) {
        foreach my $row (@$data) {
            if ($has_editable_fields) {
                delete($row->{'editable_fields'}{$_})
                  foreach grep {!$available_fields{$_}} keys(%{$row->{'editable_fields'}});
            }

            if ($has_available_fields) {
                delete($row->{'available_fields'}{$_})
                  foreach grep {!$available_fields{$_}} keys(%{$row->{'available_fields'}});
            }
        }
    }

    return $data;
}

sub get_all_available_fields {
    my ($self) = @_;

    my $relationships = RestApi::Relationships->relationships($self->{'accessor'});

    my $resource = $self->accessor();
    return $self->api_available_fields(), map {$_->[0]} map {@$_} values(%$relationships);
}

sub get_params_for_defaults {
    my ($self) = @_;

    my $params = {
        attributes => {
            from_json => TRUE,
            ref_type  => 'HASH',
            default   => '{}',
        },
        fields => {
            split_by => qr/,/,
            ref_type => 'ARRAY',
            default  => '',
        },
        changed_fields => {
            split_by => qr/,/,
            ref_type => 'ARRAY',
            default  => '',
        },
    };
    $self->get_extra_params_for_defaults($params);
    return $params;
}

sub fix_params_for_defaults {
    my ($self, $opts) = @_;
    $self->fix_extra_params_for_defaults($opts);
}

sub get_extra_params_for_defaults { }

sub fix_extra_params_for_defaults { }

TRUE;
