package RestApi::Errors;

use qbit;

use Exporter qw(import);
our @EXPORT = qw(
  ERROR__NEED_AUTH
  ERROR__PARAMS
  ERROR__CONFLICT
  ERROR__FORBIDDEN
  ERROR__VALIDATION
  ERROR__INTERNAL
  ERROR__NOT_FOUND
  ERROR__MANY_REQ
  ERROR__NOT_ACCEPTABLE
  ERROR__MEDIA_TYPE
  ERROR__NOT_IMPLEMENTED
  );
our @EXPORT_OK = @EXPORT;

use constant ERROR__NEED_AUTH       => 0;
use constant ERROR__PARAMS          => 1;
use constant ERROR__CONFLICT        => 2;
use constant ERROR__FORBIDDEN       => 3;
use constant ERROR__VALIDATION      => 4;
use constant ERROR__INTERNAL        => 5;
use constant ERROR__NOT_FOUND       => 6;
use constant ERROR__MANY_REQ        => 7;
use constant ERROR__NOT_ACCEPTABLE  => 8;
use constant ERROR__MEDIA_TYPE      => 9;
use constant ERROR__NOT_IMPLEMENTED => 10;

our $ERRORS = {
    ERROR__NEED_AUTH() => {
        id        => ERROR__NEED_AUTH,
        title     => d_gettext('Unauthorized'),
        http_code => 401,
    },
    ERROR__PARAMS() => {
        id        => ERROR__PARAMS,
        title     => d_gettext('Bad Request'),
        http_code => 400,
    },
    ERROR__CONFLICT() => {
        id        => ERROR__CONFLICT,
        title     => d_gettext('Conflict'),
        http_code => 409,
    },
    ERROR__FORBIDDEN() => {
        id        => ERROR__FORBIDDEN,
        title     => d_gettext('Forbidden'),
        http_code => 403,
    },
    ERROR__VALIDATION() => {
        id        => ERROR__VALIDATION,
        title     => d_gettext('Validation error'),
        http_code => 400,
    },
    ERROR__INTERNAL() => {
        id        => ERROR__INTERNAL,
        title     => d_gettext('Internal error'),
        http_code => 500,
    },
    ERROR__NOT_FOUND() => {
        id        => ERROR__NOT_FOUND,
        title     => d_gettext('Not found'),
        http_code => 404,
    },
    ERROR__MANY_REQ() => {
        id        => ERROR__MANY_REQ,
        title     => d_gettext('Too Many Requests'),
        http_code => 429,
    },
    ERROR__NOT_ACCEPTABLE() => {
        id        => ERROR__NOT_ACCEPTABLE,
        title     => d_gettext('Not Acceptable'),
        http_code => 406,
    },
    ERROR__MEDIA_TYPE() => {
        id        => ERROR__MEDIA_TYPE,
        title     => d_gettext('Unsupported Media Type'),
        http_code => 415,
    },
    ERROR__NOT_IMPLEMENTED() => {
        id        => ERROR__NOT_IMPLEMENTED,
        title     => d_gettext('Not implemented'),
        http_code => 501,
    },
};

1;
