package RestApi::MultistateModel;

use qbit;

use base qw(RestApi::DBModel);

use Exception::Validation::BadArguments;

sub operation_to_action {
    return (archive => 'delete');
}

sub api_edit {
    my ($self, $public_id, %attributes) = @_;
    return $self->do_action($public_id, 'edit', %attributes);
}

sub api_get_all {
    my ($self, %opts) = @_;

    my %available_fields = map {$_ => TRUE} $self->get_all_available_fields();

    my @bad_fields           = ();
    my $has_action           = FALSE;
    my $has_editable_fields  = FALSE;
    my $has_available_fields = FALSE;
    foreach (grep {$_ ne 'public_id'} @{$opts{'fields'}}) {
        push(@bad_fields, $_) unless $available_fields{$_};

        if ($_ eq 'actions') {
            $has_action = TRUE;
        } elsif ($_ eq 'editable_fields') {
            $has_editable_fields = TRUE;
        } elsif ($_ eq 'available_fields') {
            $has_available_fields = TRUE;
        }
    }

    throw Exception::Validation::BadArguments gettext('Unexpected fields: %s', join(', ', @bad_fields)) if @bad_fields;

    push(@{$opts{'fields'}}, 'available_fields') unless $has_available_fields;

    my $data = $self->get_all(%opts);

    delete($self->{'__LAST_FIELDS__'}{'available_fields'}) unless $has_available_fields;

    if ($has_action || $has_editable_fields || $has_available_fields) {

        my $resource = $self->accessor();

        my %actions;
        %actions = map {$_ => 1} $self->api_available_actions() if $has_action;

        my %action_to_operation = reverse $self->operation_to_action();

        foreach my $row (@$data) {
            if ($has_action) {
                foreach (keys(%{$row->{'actions'}})) {
                    unless ($actions{$_}) {
                        delete($row->{'actions'}{$_});
                        next;
                    }

                    if ($action_to_operation{$_}) {
                        $row->{'actions'}{$action_to_operation{$_}} = delete($row->{'actions'}{$_});
                    }
                }
            }

            if ($has_editable_fields) {
                my %noneditable_fields = $self->api_noneditable_fields;
                delete($row->{'editable_fields'}{$_})
                  foreach grep {!$available_fields{$_} || $noneditable_fields{$_}} keys(%{$row->{'editable_fields'}});
            }

            if ($has_available_fields) {
                delete($row->{'available_fields'}{$_})
                  foreach grep {!$available_fields{$_}} keys(%{$row->{'available_fields'}});
            }
        }
    }

    return $data;
}

TRUE;
