package RestApi::Relationships;

use qbit;

my $RELATIONSHIPS = {
    #SOURCES
    'mobile_app' => {'mobile_app_settings' => [['id', 'application_id']],},
    #PAGES
    'pages' => {
        'context_on_site_adblock'          => [['page_id', 'page_id']],
        'context_on_site_content'          => [['page_id', 'campaign_id']],
        'context_on_site_direct'           => [['page_id', 'campaign_id']],
        'context_on_site_natural'          => [['page_id', 'campaign_id']],
        'context_on_site_rtb'              => [['page_id', 'page_id']],
        'internal_context_on_site_content' => [['page_id', 'campaign_id']],
        'internal_context_on_site_natural' => [['page_id', 'campaign_id']],
        'internal_context_on_site_rtb'     => [['page_id', 'campaign_id']],
        'mobile_app_rtb'                   => [['page_id', 'page_id']],
        'video_an_site_fullscreen'         => [['page_id', 'page_id']],
        'video_an_site_inpage'             => [['page_id', 'page_id']],
        'video_an_site_instream'           => [['page_id', 'page_id']],
    },
    'context_on_site_campaign' => {
        #context_on_site_campaign.page_id => context_on_site_rtb.campaign_id
        'blocks'                  => [['page_id', 'page_id']],
        'context_on_site_adblock' => [['page_id', 'page_id']],
        'context_on_site_content' => [['page_id', 'campaign_id']],
        'context_on_site_direct'  => [['page_id', 'campaign_id']],
        'context_on_site_natural' => [['page_id', 'campaign_id']],
        'context_on_site_rtb'     => [['page_id', 'page_id']],
        'context_on_site_stripe'  => [['page_id', 'campaign_id']],
    },
    'internal_context_on_site_campaign' => {
        'internal_context_on_site_content' => [['page_id', 'campaign_id']],
        'internal_context_on_site_natural' => [['page_id', 'campaign_id']],
        'internal_context_on_site_rtb'     => [['page_id', 'campaign_id']],
    },
    'mobile_app_settings' => {
        'blocks'         => [['context_page_id', 'page_id']],
        'mobile_app_rtb' => [['context_page_id', 'page_id']],
    },
    'internal_mobile_app' => {
        'blocks'                  => [['id', 'campaign_id']],
        'internal_mobile_app_rtb' => [['id', 'page_id']],
    },
    'video_an_site' => {
        'blocks'                   => [['id', 'page_id']],
        'video_an_site_instream'   => [['id', 'page_id']],
        'video_an_site_inpage'     => [['id', 'page_id']],
        'video_an_site_fullscreen' => [['id', 'page_id']],
    },
    'indoor' => {
        'blocks'       => [['page_id', 'page_id']],
        'indoor_block' => [['page_id', 'page_id']]
    },
    'outdoor' => {
        'blocks'        => [['page_id', 'page_id']],
        'outdoor_block' => [['page_id', 'page_id']]
    },
    'context_on_site_content'          => {'fast_ban' => [['campaign_id', 'page_id'], ['id', 'block_id']],},
    'internal_context_on_site_content' => {'fast_ban' => [['campaign_id', 'page_id'], ['id', 'block_id']],},
    #BLOCKS
    #'context_on_site_rtb' => {'brands' => [['campaign_id', 'page_id'], ['id', 'block_id']]},
    #context_on_site_rtb.campaign_id => brands.page_id, context_on_site_rtb.id => brands.block_id
};

my $reverse_relationships = {};
foreach my $f (sort keys(%$RELATIONSHIPS)) {
    foreach my $s (sort keys(%{$RELATIONSHIPS->{$f}})) {
        next if $reverse_relationships->{$f}{$s};

        throw gettext('Duplicate models in relationships "%s"', "$f->$s")
          if exists($RELATIONSHIPS->{$s}{$f});

        $RELATIONSHIPS->{$s}{$f} = [map {[$_->[1], $_->[0]]} @{$RELATIONSHIPS->{$f}{$s}}];
        $reverse_relationships->{$s}{$f} = TRUE;
    }
}

sub relationships {
    my ($class, $accessor) = @_;
    return $RELATIONSHIPS->{$accessor} // {};
}

TRUE;
