package RestApi::SimpleModel::Errors;

use qbit;

use base qw(QBit::Application::Model RestApi::SimpleModel);

use RestApi::Errors;

sub accessor {'errors'}

__PACKAGE__->register_rights(
    [
        {
            name        => 'errors',
            description => d_gettext('Right to manage errors'),
            rights      => {view_errors => d_gettext('Right to view errors'),}
        }
    ]
);

sub get_product_name {gettext('Errors')}

sub api_available_fields {
    return qw(title);
}

sub api_available_actions {
    return qw();
}

sub api_check_public_id {$_[1] =~ /^[a-z_]+$/}

sub api_get_all {
    my ($self, $controller, $resource, $one_object) = @_;

    $controller->check_params(($one_object ? 'public_id' : ()), "fields[$resource]");

    my @fields = $controller->get_fields($resource);

    my $url_simple_model_get = $controller->get_abs_for_sprintf('simple_model__resource_get', qw(resource public_id));

    my %fields = map {$_ => TRUE} @fields;

    my @result = ();
    foreach my $err (values(%$RestApi::Errors::ERRORS)) {
        my $res = {
            type => $resource,
            id   => "$err->{'id'}",
            ($one_object ? () : (links => {self => sprintf($url_simple_model_get, $resource, $_),})),
        };

        $res->{'attributes'}{'title'} = $err->{'title'}->() if $fields{'title'};

        push(@result, $res);
    }

    return \@result;
}

TRUE;
