package RoleRights;

use qbit;

use Exporter qw(import);
use PiConstants qw($DEVELOPER_ROLE_ID $YAN_MANAGER_ROLE_ID $INTERNAL_YAN_ADMINISTRATOR_ROLE_ID $DSP_MANAGER_ROLE_ID);

our @EXPORT_OK = qw( get_role_right_object_by_stage );

use lib::abs;
use constant TSV_FILE => lib::abs::path("./role_rights.ssv");

my $WIDTH;
our $cache = {
    # <stage> => $obj,
};

sub new {
    my ($class, $stage) = @_;

    my $self = $cache->{$stage};

    unless ($self) {
        $class = blessed($class) // $class;

        $self = _read_role_right($stage);

        bless($self, $class);

        $cache->{$stage} = $self;
    }
    return $self;
}

sub _read_role_right {
    my ($stage) = @_;

    $WIDTH = 0;

    my $data = {
        #  <right_name> => {
        #    <role_id> => 1,
        #    ...
        #  },
        #  ...
    };
    open(my $fh, '<', TSV_FILE) or die $!;
    while (my $line = <$fh>) {
        if ($line and substr($line, 0, 1) ne "#") {
            my ($key, $value) = grep {$_} split /\s+/, $line;
            $WIDTH = length $key if $WIDTH < length $key;
            $data->{$key} = {map {$_ => 1} split /,/, $value};
        }
    }
    close $fh;

    if (in_array($stage, ['production', 'preprod', 'autotest'])) {
        # use original data
    } elsif ($stage eq 'test' or $stage eq 'dev') {

        $data->{fake_login}->{$DEVELOPER_ROLE_ID}   = 1;    # Разработчик
        $data->{fake_login}->{$YAN_MANAGER_ROLE_ID} = 1;    # Рекламная сеть: Менеджер
        $data->{fake_login}->{$INTERNAL_YAN_ADMINISTRATOR_ROLE_ID} =
          1;                                                # Сервисы Яндекса: Администратор
        $data->{fake_login}->{$DSP_MANAGER_ROLE_ID} = 1;    # DSP: Менеджер

        # PI-1177 start
        $data->{run_cron_job}->{$DEVELOPER_ROLE_ID}  = 1;
        $data->{view_cron_job}->{$DEVELOPER_ROLE_ID} = 1;
        # PI-1177 end

        # PI-2042 start
        $data->{devel_lego_test}->{$DEVELOPER_ROLE_ID} = 1;
        # PI-2042 end

        # PI-4850 start
        $data->{create_or_update_place_switch}->{$DEVELOPER_ROLE_ID} = 1;
        # PI-4850 end

    } else {
        throw Exception "Unknown stage name: $stage";
    }

    return $data;
}

sub get_role_right_object_by_stage {
    my ($stage) = @_;
    my $obj = $cache->{$stage};
    unless ($obj) {
        $obj = RoleRights->new($stage);
    }
    return $obj;
}

sub get_rights {
    my ($self) = @_;
    return {%$self};
}

sub get_roles_rights {
    my ($self, $role_ids, $fields) = @_;

    my $res = {};
    if (defined $role_ids) {
        $res = $self->get_rights_by_role_ids($role_ids);
    } else {
        $res = $self->get_rights();
    }

    my $with_rights  = !!grep {$_ eq 'right'} @$fields;
    my $with_role_id = !!grep {$_ eq 'role_id'} @$fields;

    my @result;
    foreach my $right (keys %$res) {
        foreach (keys %{$res->{$right}}) {
            my $row = {($with_rights ? (right => $right) : ()), ($with_role_id ? (role_id => $_) : ())};
            push @result, $row;
        }
    }

    @result = sort {
        my ($firstly, $secondly) = (0, 0);
        if ($with_rights) {
            $firstly = $a->{right} cmp $b->{right};
        }
        if ($with_role_id) {
            $secondly = $a->{role_id} <=> $b->{role_id};
        }
        $firstly || $secondly;
    } @result;

    return \@result;
}

sub get_rights_by_role_ids {
    my ($self, $role_ids) = @_;

    my $role_rights = $self->get_rights();
    my $res         = {};

    foreach my $right (keys %$role_rights) {
        foreach (@$role_ids) {
            if (exists $role_rights->{$right}->{$_}) {
                if (exists $res->{$right}) {
                    $res->{$right}->{$_} = 1;
                } else {
                    $res->{$right} = {$_ => 1};
                }
            }
        }
    }

    return $res;
}

sub set {
    my ($self, $rights) = @_;

    foreach my $right (keys %$rights) {
        $WIDTH = length $right if $WIDTH < length $right;
        $self->{$right} = {map {$_ => 1} @{$rights->{$right}}};
    }
}

sub cur_max_right_width {
    return $WIDTH;
}

sub dump {
    my ($self) = @_;

    my $data = $self->get_rights();

    my @strs = map {
        sprintf("%*s%s", -($WIDTH + 5), $_, join(',', sort {$a <=> $b} keys %{$data->{$_}}))
    } sort keys %$data;
    writefile(TSV_FILE, join("\n", @strs) . "\n");
}

1;
