
=encoding UTF-8
=cut

=head1 Название

Test::Utils - общие сабы, которые используются в тестах

=cut

package Test::Utils;

use qbit;
use File::Temp;
use Locale::PO;

sub get_all_msgids_from_po {
    my ($po_content) = @_;

    my %h = get_hash_from_po($po_content);

    my @msgids = sort keys %h;
    return @msgids;
}

sub get_hash_from_po {
    my ($po_content) = @_;

    my $fh       = File::Temp->new();
    my $filename = $fh->filename;

    writefile($filename, $po_content);

    my %h;

    foreach my $element (@{Locale::PO->load_file_asarray($filename)}) {

        my $msgid        = _get_msg($element->msgid());
        my $msgstr       = _get_msg($element->msgstr());
        my $msgid_plural = _get_msg($element->msgid_plural());

        next if $msgid eq '';

        if ($msgstr ne '') {
            $h{$msgid} = $msgstr;
        } elsif ($msgid_plural ne '') {
            $h{$msgid} = $msgid_plural;
        } else {
            $h{$msgid} = '';
        }

    }

    return %h;
}

sub _get_msg {
    my ($msg) = @_;

    return '' if !defined $msg;

    $msg =~ s{^"(.*)"$}{$1};
    utf8::decode($msg);

    return $msg;
}

1;
