package Utils::Betas;

use qbit;

use base qw(QBit::Class);

use lib::abs;

our $PATH = "$ENV{'HOME'}/.betas_storage.json";

sub init {
    my ($self) = @_;

    if (-e $PATH) {
        my $betas_json = readfile($PATH);

        try {
            $self->{'__STORAGE__'} = from_json($betas_json);
        }
        catch {
            throw Exception "Incorrect json in file: $PATH";
        };
    } else {
        printf("Storage does not exists: %s\n", $PATH);
    }

    return $self;
}

sub add {
    my ($self, $project, $stage) = @_;

    $self->{'__STORAGE__'}{'projects'}{$project}{$stage} = {create_datetime => curdate(oformat => 'db_time'),};

    $self->{'__STORAGE__'}{'last_stage'} = [$project, $stage];

    $self->dump();
}

sub dump {
    my ($self) = @_;

    writefile($PATH, to_json($self->{'__STORAGE__'}, pretty => TRUE));
}

TRUE;
