package Utils::ClickHouse::Local;

use base qw(QBit::Class);

use qbit;

use QBit::Application;

use File::Slurp qw(read_file);
use File::Temp qw(tempfile);

use Exception::ClickHouse;

sub init {
    my ($self) = @_;

    $self->SUPER::init();

    my @missing = grep {!exists($self->{$_})} qw(input_files output_file structure);

    throw Exception::ClickHouse 'No value specified for parameters: ' . join(',', @missing)
      if @missing;

    $self->structure($self->{structure});

}

sub structure {
    my ($self, $new_structure) = @_;

    return $self->{structure} unless defined $new_structure;

    $self->{structure} = $new_structure;

    my @variable_definitions;

    my $num_of_vars = @{$self->{structure}} / 2;
    for my $i (0 .. $num_of_vars - 1) {
        push @variable_definitions, "$self->{structure}[2*$i] $self->{structure}[2*$i + 1]";
    }

    $self->{_vars} = join(',', @variable_definitions);
}

sub query {
    my ($self, $query) = @_;

    my $input_files = join(' ', @{$self->{input_files}});
    my $stdout_file = $self->{output_file};
    my $stderr_file = (tempfile(UNLINK => 1))[1];

    my $shell_string = qq(bash -c "set -o pipefail; cat $input_files 2>$stderr_file) . ' | '
      . qq(clickhouse-local -S '$self->{_vars}' --query='$query' 1>$stdout_file 2>>$stderr_file");

    my $exit_status = system($shell_string);

    if ($exit_status != 0) {
        if ($exit_status == -1) {
            throw Exception::ClickHouse "Failed to start clickhouse-local: $!";
        } else {
            my $stderr = read_file($stderr_file);
            throw Exception::ClickHouse
              "clickhouse-local exited with non-zero status $exit_status. stderr dump:\n$stderr";
        }
    }

    return $self;
}

1;
