package Utils::Cron;

use Time::Local;

our @ISA = qw(Exporter);

our @EXPORT = qw(
  get_ttl_from_cron_time_date_fields
  proc_memory
  proc_status
  proc_status_str
  get_method_and_instance_number
  );

use List::Util qw(min);
use qbit;
use Schedule::Cron::Events;

=head2 get_ttl_from_cron_time_date_fields

    my $seconds = get_ttl_from_cron_time_date_fields();

Возвращает int число - количество секунд.

=cut

sub get_ttl_from_cron_time_date_fields {
    my ($time_date) = @_;

    my $sce = Schedule::Cron::Events->new($time_date);

    my $timestamp_next_run       = timegm($sce->nextEvent());
    my $timestamp_after_next_run = timegm($sce->nextEvent());

    my $seconds = $timestamp_after_next_run - $timestamp_next_run;

    # увеличиваем на 20%, но не больше чем сутки
    $seconds = $seconds + min(86_400, int($seconds * 0.2));

    # и не меньше часа
    $seconds = 3600 if $seconds < 3600;

    # juggler не позволяет указать ttl больше чем 864000
    $seconds = min(864000, $seconds);

    return $seconds;
}

sub proc_memory(;$) {
    my $stat = proc_status(@_);
    die "No VmRSS field in /proc/PID/status" if !defined $stat->{VmRSS};
    return ($stat->{VmRSS});
}

sub proc_status(;$) {
    my $pid = shift || $$;
    my $file = "/proc/$pid/status";
    open(my $fd, "<", $file) || die "Can't open file '$file': $!";
    my %status;
    local $/ = "\n";
    while (my $stream = <$fd>) {
        if ($stream =~ /^(\w+):\s+(.+)/) {
            $status{$1} = $2;
        }
    }
    return \%status;
}

sub proc_status_str {
    my $mem = proc_memory();
    my ($cpu_user, $cpu_sys) = times;
    return sprintf("Status: memory=%dMb, cpu_user=%0.2f, cpu_sys=%0.2f", $mem / 1024 / 1024, $cpu_user, $cpu_sys);
}

sub get_method_and_instance_number {
    my ($full_method) = @_;

    my $method = $full_method;

    my $instance_number;
    if ($method =~ s/(?:_([0-9]+))\z//) {
        $instance_number = $1;
    }

    return ($method, $instance_number);
}

TRUE;
