package Utils::Deploy::Secrets;

use qbit;
use Exporter;

our @ISA    = qw(Utils::Deploy);
our @EXPORT = qw(load_secrets_tokens);

my $DELEGATE_TOKENS_SECRET = 'sec-01ekyevjawtb1sq88ksjby3kkh';

sub load_secrets_tokens {
    my ($secrets, $stage_name, $deploy_unit_name, $yav_token) = @_;

    my $secrets_tokens = get_last_secret_version($DELEGATE_TOKENS_SECRET, $yav_token)->{'value'};
    my $secrets_data = {};

    foreach my $secret_id (@$secrets) {
        my $delegation_key = "$secret_id.$stage_name.$deploy_unit_name";
        print "Getting info about secret:\n";
        print "\tSecret ID: $secret_id\n";
        print "\tStage name: $stage_name\n";
        print "\tDeploy unit: $deploy_unit_name\n";

        my $delegation_token = "";
        if (exists($secrets_tokens->{$delegation_key})) {
            $delegation_token = $secrets_tokens->{$delegation_key};
        } else {
            $delegation_token = from_json(
                run_shell(
                    "yav create token $secret_id -tvm 2001151 -s '$stage_name.$deploy_unit_name' -j --oauth=$yav_token",
                    silent => 1
                ),
                use_pp => TRUE,
            )->{'token'};
            run_shell(
"yav create version $DELEGATE_TOKENS_SECRET -u -k '$delegation_key=$delegation_token' --oauth=$yav_token",
                silent => 1
            );
        }
        my $secret_info = get_last_secret_version($secret_id, $yav_token);
        my $secret_key = "$secret_info->{secret_name}:$secret_info->{secret_uuid}";
        $secrets_data->{$secret_key} = {
            delegation_token => $delegation_token,
            secret_id        => $secret_info->{secret_uuid},
            secret_version   => $secret_info->{version},
        };
    }
    return $secrets_data;
}

sub get_last_secret_version {
    my ($secret_id, $yav_token) = @_;

    my $versions     = get_secret_info($secret_id, $yav_token)->{'secret_versions'};
    my $last_version = '';
    my $last_update  = 0;
    foreach my $version (@$versions) {
        if ($last_update < $version->{'created_at'}) {
            $last_update  = $version->{'created_at'};
            $last_version = $version->{'version'};
        }
    }
    if ($last_update == 0) {
        croak("Can`t find version for '$secret_id' secret");
    }
    my $version_data =
      from_json(run_shell("yav get version $last_version -j --oauth=$yav_token", silent => 1), use_pp => TRUE);

    return $version_data;
}

sub get_secret_info {
    my ($secret_id, $yav_token) = @_;
    my $result = from_json(run_shell("yav get secret $secret_id -j --oauth=$yav_token", silent => 1), use_pp => TRUE);
    return $result;
}

TRUE;
