package Utils::Dict;

use qbit;

my $cpm_multiplier = 1000;

sub get_cmp_from_tree {
    my ($self, $list, $tree) = @_;

    my $result = {};

    return $result if !defined($list) || @$list == 0;

    my %all_cpm = map {$_->{'id'} => $_->{'cpm'}} @$list;

    # Начинаю двигатся по дереву. Если я попадая на элемент у которого есть
    # настройка пользователя, то я выставляю указанный cpm. Если настройки
    # нет, то я смотрю, есть ли настройка у родителя и если у родителя есть
    # cpm, то использую этот cpm и у текущего элемент.

    my $pk = $self->get_pk_fields()->[0];
    $tree->traverse(
        sub {
            my ($element) = @_;

            my $value = $element->getNodeValue();

            if ($all_cpm{$value->{$pk}}) {
                $result->{$value->{$pk}} = {
                    currency => 'RUB',
                    value    => $all_cpm{$value->{$pk}} * ($all_cpm{$value->{$pk}} > 0 ? $cpm_multiplier : 1),
                };
            } else {
                my $parent = $element->getParent->getNodeValue();

                if ($all_cpm{$parent->{$pk}}) {
                    $all_cpm{$value->{$pk}} = $all_cpm{$parent->{$pk}};

                    $result->{$value->{$pk}} = {
                        currency => 'RUB',
                        value    => $all_cpm{$parent->{$pk}} * ($all_cpm{$parent->{$pk}} > 0 ? $cpm_multiplier : 1),
                    };
                }
            }
        }
    );

    return $result;
}

1;
