package Utils::DockerRegistry;

use Exporter;
use HTTP::Request;
use IO::Socket::SSL qw(SSL_VERIFY_NONE);
use LWP::UserAgent;

use qbit;
use PiSecrets qw(get_secret);

our @ISA       = qw(Exporter);
our @EXPORT_OK = qw(
  get_last_docker_db_image_tag
  );
our @EXPORT = @EXPORT_OK;

sub get_last_docker_db_image_tag {
    my ($db_image) = @_;
    my $url = 'https://registry.yandex.net/v2/' . $db_image . '/tags/list';

    my $oauth_token = get_secret('registry-token');

    my $browser = LWP::UserAgent->new(
        timeout  => 180,
        ssl_opts => {
            verify_hostname => 0,
            SSL_verify_mode => SSL_VERIFY_NONE
        }
    );

    my $request = HTTP::Request->new(GET => $url);
    $request->header('Authorization' => "OAuth $oauth_token");

    my $image_tag;
    my $try = 3;
    while ($try--) {
        eval {
            my $response = $browser->request($request);

            if ($response->is_success()) {
                my $data = from_json($response->decoded_content);
                my @tags = grep {m/^\d+\.\d+\.\d+-\d{4}-\d{2}-\d{2}$/} @{$data->{'tags'}};
                $image_tag = [sort {$b cmp $a} @tags]->[0];
            }
        };

        l $@ if $@;

        last if $image_tag;

        sleep(3);
    }

    die 'Can not get docker db image tag' unless defined($image_tag);

    return $image_tag;
}

TRUE;
