package Utils::DomainBK;

=encoding UTF-8
=cut

=head1 Название

Utils::DomainBK - модуль для работы с доменами

=head1 Описание

=cut

use qbit;

our @ISA    = qw(Exporter);
our @EXPORT = qw(
  @DEFAULT_VIDEO_MIRRORS
  check_domains_for_absorption

  );

our @EXPORT_OK = @EXPORT;

our @DEFAULT_VIDEO_MIRRORS = qw(
  iframe-toloka.com
  kinopoisk.ru
  yadi.sk
  yandex.az
  yandex.by
  yandex.co.am
  yandex.co.il
  yandex.com
  yandex.com.am
  yandex.com.ge
  yandex.com.tr
  yandex.ee
  yandex.fr
  yandex.kg
  yandex.kz
  yandex.lt
  yandex.lv
  yandex.md
  yandex.net
  yandex.ru
  yandexsport.by
  yandexsport.kz
  yandexsport.ru
  yandexsport.uz
  yandex-team.ru
  yandex.tj
  yandex.tm
  yandex.ua
  yandex.uz
  yastatic.net
  );

# ['yandex.ru', 'partner.yandex.ru', 'test.com']
# => split and reverse
# [['ru', 'yandex'], ['ru', 'yandex', 'partner'], ['com, 'test']]
# => convert to trie
# {
#     'ru' => {
#         'yandex' => {
#             '#END#' => 1,
#             'partner' => {
#                 '#END#' => 1,
#             },
#         },
#     },
#     'com' => {
#         'test' => {
#             '#END#' => 1,
#         },
#     },
# }
# => lookup all domains and filter subdomains out =>
# ['yandex.ru', 'test.com']
sub check_domains_for_absorption {
    my ($domains) = @_;

    my $end_marker = '#END#';

    my @ascii_reversed_split_domains =
      map {[reverse(split(m/\./, get_domain($_, ascii => TRUE, www => TRUE)))]} @$domains;

    my $trie = {};

    # Traverse domains - build trie
    for my $domain (@ascii_reversed_split_domains) {
        my $trie_node = $trie;
        for my $subdomain (@$domain) {
            $trie_node = ($trie_node->{$subdomain} //= {});
        }
        # Mark this node as a whole domain
        $trie_node->{$end_marker} = 1;
    }

    my @result;

    # Traverse domains one more time - filter out subdomains
  DOMAIN:
    for my $domain (@ascii_reversed_split_domains) {
        my $trie_node = $trie;
        for my $subdomain (@$domain) {
            # Found superdomain of this domain. Skipping
            next DOMAIN if $trie_node->{$end_marker};
            # Else one level deeper
            $trie_node = $trie_node->{$subdomain};
        }

        my $normal_domain = join('.', reverse(@$domain));
        die "End marker not found for $normal_domain."
          unless $trie_node->{$end_marker};
        push @result, $normal_domain;
    }

    return @result;
}

TRUE;
