package Utils::Fias;

use qbit;

use base qw(Exporter);

sub query_fias {
    my ($app, %opts) = @_;

    return $app->partner_db->fias->get_all(
        fields => [qw(guid obj_level formal_name short_name)],
        filter => [
            AND => [
                (
                    $opts{guid}
                    ? ['guid', '=', \$opts{guid}]
                    : ['parent_guid', '=', \$opts{parent_guid}]
                ),
            ]
        ],
    );
}

sub fias_hierarchy {
    my ($app, %opts) = @_;

    my @elements;
    my $parent_guid;

    do {
        my $element = $app->partner_db->fias->get_all(
            fields => [qw(formal_name guid obj_level parent_guid short_name)],
            filter => {($parent_guid ? (guid => $parent_guid) : (guid => $opts{guid})),},
        )->[0];

        push @elements, $element if defined($element);

        $parent_guid = $element->{parent_guid};

    } until !defined($parent_guid);

    return \@elements;
}

TRUE;
