package Utils::HookStash;
use qbit;

sub new {
    my ($class) = @_;
    my $self;
    return bless \$self, $class;
}

sub init {
    my ($self, %opts) = @_;

    throw Exception gettext('Already inited') if $self->inited;

    my $data  = delete $opts{data}  || {};
    my $once  = delete $opts{once}  || [];
    my $free  = delete $opts{free}  || [];
    my $merge = delete $opts{merge} || {};
    my $mode  = delete $opts{mode}  || [];
    $mode = [$mode] unless ref $mode eq 'ARRAY';

    throw Exception gettext('%s fields in %s: %s', 'Unexpected', 'args', join(', ', sort keys %opts)) if %opts;

    my %once = map {$_ => undef} @$once;
    my %free = map {$_ => undef} @$free;
    my %mode = map {$_ => undef} @$mode;

    if (my @test = grep {exists $data->{$_}} @$once) {
        throw Exception gettext('%s fields in %s: %s', 'once', 'data', join(', ', @test));
    }

    if (my @test = grep {exists $free{$_}} @$once) {
        throw Exception gettext('%s fields in %s: %s', 'once', 'free', join(', ', @test));
    }

    my $object = {
        _data  => $data,
        _once  => \%once,
        _free  => \%free,
        _mode  => \%mode,
        _merge => $merge,
    };
    $$self = $object;
    weaken($$self);

    return $$self;
}

sub inited {
    my ($self) = @_;
    return $$self;
}

sub check {
    my ($self, $field) = @_;
    throw Exception gettext('Not inited') unless $self->inited;
    return exists $$$self{_data}{$field};
}

sub set {
    my ($self, $field, $value) = @_;
    throw Exception gettext('Not inited') unless $self->inited;
    if (exists $$$self{_once}{$field}) {
        $$$self{_data}{$field} = $value;
        delete $$$self{_once}{$field};
    } elsif (exists $$$self{_free}{$field}) {
        $$$self{_data}{$field} = $value;
    } else {
        throw Exception gettext('Cannot modify "%s"', $field);
    }
}

sub get {
    my ($self, $field) = @_;
    throw Exception gettext('Not inited') unless $self->inited;
    if (exists $$$self{_data}{$field}) {
        return $$$self{_data}{$field};
    } elsif (exists $$$self{_merge}{$field}) {
        my $result = {};
        foreach (@{$$$self{_merge}{$field}}) {
            $result = {%$result, %{$self->get($_)}};
        }

        return $result;
    } else {
        throw Exception gettext('Cannot get "%s"', $field);
    }
}

sub mode {
    my ($self, @modes) = @_;
    throw Exception gettext('Not inited') unless $self->inited;
    return 0 < grep {exists $$$self{_mode}{$_}} @modes;
}

1;
