package Utils::InternalPagesInEurope;

use qbit;

use base qw(Exporter);

our @EXPORT    = qw(remove_european_domains_from_mirrors);
our @EXPORT_OK = @EXPORT;

my %EUROPEAN_DOMAINS = map {$_ => TRUE} qw(
  yandex.lv
  yandex.lt
  yandex.pl
  yandex.fi
  yandex.ee
  m.yandex.lv
  m.yandex.lt
  m.yandex.pl
  m.yandex.fi
  m.yandex.ee
  );

my %INTERNAL_PAGES_IN_EUROPE = map {$_ => TRUE} qw(
  136
  242
  48058
  49688
  84912
  88848
  101833
  126291
  142300
  143156
  146642
  148395
  155720
  174807
  174875
  187644
  241834
  244345
  247340
  247351
  247357
  247361
  247362
  248072
  249019
  253184
  255785
  256724
  262494
  262495
  262496
  262497
  262498
  262639
  262640
  262641
  262642
  262643
  262644
  262645
  262646
  262647
  264431
  265853
  270715
  271427
  273631
  274145
  275454
  275464
  276040
  276217
  276691
  276692
  276699
  276700
  276828
  277179
  277180
  278394
  281222
  281769
  284021
  284079
  285286
  285287
  285292
  290757
  291962
  291966
  292227
  292233
  292256
  292261
  292262
  295672
  295673
  295675
  295676
  338730
  338731
  338734
  338735
  338744
  338745
  338746
  338747
  343348
  343349
  343350
  343351
  343357
  343363
  343380
  345620
  346322
  346633
  346653
  346823
  347727
  349254
  355967
  355968
  355969
  357845
  357846
  357847
  357848
  357852
  357856
  357860
  357862
  357865
  357868
  357869
  383295
  383297
  395614
  395625
  404403
  405090
  405136
  422899
  441153
  441228
  441229
  457240
  457241
  457242
  457243
  457248
  457249
  458046
  460997
  460998
  460999
  461001
  461002
  461003
  461005
  461006
  461007
  461009
  461010
  461011
  461012
  461013
  461014
  461015
  461016
  461017
  462006
  462007
  466298
  466310
  466333
  466336
  466337
  466667
  474446
  474447
  474448
  474449
  474654
  474674
  476060
  477696
  477697
  477698
  477699
  478428
  478429
  478430
  478431
  478432
  480598
  482658
  508636
  508649
  509526
  509527
  509711
  509724
  509726
  509727
  509728
  509729
  509730
  509731
  509732
  509733
  509734
  509736
  509753
  509754
  509756
  509757
  511280
  511282
  511284
  511285
  );

sub remove_european_domains_from_mirrors {
    my ($bk_data) = @_;

    if (   exists($bk_data->{'mirrors'})
        && defined($bk_data->{'page_id'})
        && $INTERNAL_PAGES_IN_EUROPE{$bk_data->{'page_id'}})
    {
        $bk_data->{'mirrors'} = [grep {!$EUROPEAN_DOMAINS{$_}} @{$bk_data->{'mirrors'}}];
    }
}

TRUE;
