package Utils::JSON;

use qbit;

our @ISA    = qw(Exporter);
our @EXPORT = qw(
  clean_decoded_json_from_boolean_objects_in_place
  fix_type_for_complex
  get_boolean_representation
  apply_json_patch
  );

my @SPECIAL_KEYS = qw( __PUSH__  __REPLACE__ );

sub expand_dots_in_patch_recursive {
    my ($patch, $got_upper_replace) = @_;

    if (ref($patch) eq 'HASH') {
        my $got_replace = exists $patch->{__REPLACE__};
        foreach my $key (sort keys %$patch) {
            if (ref($patch->{$key}) eq 'HASH') {
                expand_dots_in_patch_recursive($patch->{$key}, $got_upper_replace || $got_replace);
            }

            my @path = split /\./, $key;
            if (@path > 1) {
                my $is_special_keys = grep {$path[-1] eq $_} @SPECIAL_KEYS;
                my $special_key = $is_special_keys ? $path[-1] : '';
                my $is_last_key_replace = $special_key eq '__REPLACE__';

                if ($is_special_keys && !$is_last_key_replace) {
                    $path[-2] .= '.' . pop(@path);
                }

                my $path_got_upper_replace = $got_upper_replace;
                my $point                  = $patch;

                for (my $i = 0; $i < $#path; $i++) {
                    my $cur_key = $path[$i];
                    unless ($i == $#path - 1 && $is_last_key_replace) {
                        my $val = $point->{$cur_key};
                        if (!defined($val) || ref($val) ne 'HASH') {
                            $point->{$cur_key} = {};
                        }
                        $point = $point->{$cur_key};
                    }
                    $path_got_upper_replace ||= exists $point->{__REPLACE__};
                }

                if ($special_key eq '__PUSH__' && exists($point->{$path[-1]})) {
                    my $val = delete $patch->{$key};

                    # по идее такого быть не может, валидация поля patch упадет, разве кто-то ручками вызовет
                    $val = [$val] unless ref($val) eq 'ARRAY';

                    # __PUSH__ на разных уровнях в одну точку накапливается, а не затирается
                    push @{$point->{$path[-1]}}, @$val;
                } else {
                    if ($special_key eq '__REPLACE__') {
                        my $new_key = '';
                        if ($path_got_upper_replace || $got_replace) {
                            # если есть __REPLACE__ на этом же уровне то, добавлять __REPLACE_ ниже бессмысленно
                            $new_key = $path[-2];
                        } else {
                            # если __REPLACE__ нет на верхнем или текущем уровне, то приоединяем его к ключу
                            $new_key = @path < 3 ? $key : join('.', @path[-2, -1]);
                        }
                        $point->{$new_key} = delete $patch->{$key};
                    } else {
                        $point->{$path[-1]} = delete $patch->{$key};
                    }
                }
            } elsif ($key eq '__REPLACE__' && $got_upper_replace) {
                # если есть __REPLACE__ на верхнем уровне то, добавлять __REPLACE_ ниже бессмысленно
                delete $patch->{$key};
            }
        }
    }

    return 1;
}

sub apply_patch_recursive {
    my ($data, $patch, $keys_transform, $depth, $path) = @_;

    $path           //= '/';
    $depth          //= 0;
    $keys_transform //= {};

    if (ref($patch) eq 'HASH') {
        foreach my $patch_key (sort keys %$patch) {
            # чтобы у удаления был наивысший приоритет
            next if $patch_key eq '__DEL__';

            my ($real_key, $special_key) = my @path = split /\./, $patch_key;
            my $is_special_key = @path > 1 && grep {$path[-1] eq $_} @SPECIAL_KEYS;

            my $data_key = $is_special_key ? $real_key : $patch_key;

            $data_key = $keys_transform->{$data_key} if $depth == 0 && exists $keys_transform->{$data_key};

            my $patch_value = $patch->{$patch_key};
            my $data_value  = $data->{$data_key};

            if ($is_special_key) {
                if ($special_key eq '__REPLACE__') {
                    $data->{$data_key} = $patch_value;
                } elsif ($special_key eq '__PUSH__') {
                    if (!defined($data_value) || ref($data_value) ne 'ARRAY') {
                        $data->{$data_key} = [];
                    }
                    push @{$data->{$data_key}}, @$patch_value;
                }
            } else {
                if (ref($patch_value) eq 'HASH' && !exists($patch_value->{'__REPLACE__'})) {
                    $data_value = $data->{$data_key} = {} unless ref($data_value) eq 'HASH';

                    apply_patch_recursive($data_value, $patch_value, $keys_transform, $depth + 1,
                        join('->', $path, $patch_key));
                } else {
                    $data->{$data_key} = $patch_value;
                    delete $data->{$data_key}->{'__REPLACE__'} if ref($patch_value) eq 'HASH';
                }
            }
        }

        if ($patch->{'__DEL__'}) {
            foreach my $path (@{$patch->{'__DEL__'}}) {
                my @path = split /\./, $path;
                $path[0] = $keys_transform->{$path[0]}
                  if $depth == 0 && exists $keys_transform->{$path[0]};
                my $point = $data;
                my $ok    = TRUE;
                for (my $i = 0; $ok && $i < $#path; $i++) {
                    $point = $point->{$path[$i]};
                    if (ref $point ne 'HASH') {
                        $ok = FALSE;
                        last;
                    }
                }
                delete $point->{$path[-1]} if $ok;
            }
        }
    }

    return $data;
}

sub apply_json_patch {
    my ($data, $patch_json, $keys_transform) = @_;

    my $patch = from_json $patch_json;

    expand_dots_in_patch_recursive($patch);

    apply_patch_recursive($data, $patch, $keys_transform);

    return $data;
}

sub clean_decoded_json_from_boolean_objects_in_place {
    my $ref = ref($_[0]);

    if (rindex($ref, 'Boolean') != -1) {
        $_[0] = $_[0] ? 1 : 0;
    } elsif ($ref eq 'ARRAY') {
        clean_decoded_json_from_boolean_objects_in_place($_) foreach @{$_[0]};
    } elsif ($ref eq 'HASH') {
        # не конвертируем boolean поля в 1/0 для ключа design_settings
        # так как для полей которые больше никому не доступны появляется диф
        foreach (keys(%{$_[0]})) {
            next if $_ eq 'design_settings';

            clean_decoded_json_from_boolean_objects_in_place($_[0]->{$_});
        }
    }

    $_[0];
}

sub fix_type_for_complex {
    my ($model, $value) = @_;

    map {$value->{$_} = get_boolean_representation($value->{$_})} keys(%$value);

    return $value;
}

sub get_boolean_representation {
    my ($value) = @_;

    if (ref($value) eq 'SCALAR') {
        return $$value ? \1 : \0;
    } else {
        return $value ? \1 : \0;
    }
}

TRUE;
