package Utils::Oneshots;

use qbit;
use Exception::DB;
use Exception::OneshotsRepeaterFail;

our @ISA       = qw();
our @EXPORT    = qw(repeater);
our @EXPORT_OK = @EXPORT;

sub repeater {
    my ($sub, $timeout, $tries) = @_;

    return $sub->()
      if (!defined($timeout) || !defined($tries));

    my @res;

    while ($tries--) {
        try {
            @res   = $sub->();
            $tries = 0;
        }
        catch Exception::DB with {
            my ($e) = @_;
            throw Exception::OneshotsRepeaterFail $e if $tries <= 0;
            sleep $timeout;
        };
    }

    return wantarray ? @res : $res[0];
}

1;
