package Utils::Oneshots::ChangeDesignDropOldFormat;

use qbit;

our %MODES = (
    replace => {
        add    => TRUE,
        delete => TRUE,
        log    => 'CHANGE_DESIGN',
    },
    add => {
        add => TRUE,
        log => 'ADD_DESIGN',
    },
    delete => {
        delete => TRUE,
        log    => 'DELETE_DESIGN',
    },
);

my $TO_CHANGE = {
    oldPosterHorizontal => {
        name_for_deleted => 'posterHorizontal',
        name_for_active  => 'posterHorizontal',
        filter_tags      => ["adaptive", "horizontal"],
        design           => \&copy_design,
        list_for_copy    => [
            qw(
              horizontalAlign
              borderRadius
              bgColor
              borderColor
              limit
              )
        ],
    },
    oldPosterVertical => {
        name_for_deleted => 'posterVertical',
        name_for_active  => 'posterVertical',
        filter_tags      => ["adaptive", "vertical"],
        design           => \&copy_design,
        list_for_copy    => [
            qw(
              borderRadius
              bgColor
              borderColor
              limit
              )
        ],
        set_value => {horizontalAlign => \0,},
    },
    posterHorizontal2 => {
        name_for_deleted => 'posterHorizontal',
        name_for_active  => 'posterHorizontal',
        filter_tags      => ["adaptive", "horizontal"],
        design           => \&copy_design,
        list_for_copy    => [
            qw(
              horizontalAlign
              borderRadius
              limit
              )
        ],
    },
    posterVertical2 => {
        name_for_deleted => 'posterVertical',
        name_for_active  => 'posterVertical',
        filter_tags      => ["adaptive", "vertical"],
        design           => \&copy_design,
        list_for_copy    => [
            qw(
              borderRadius
              limit
              )
        ],
        set_value => {horizontalAlign => \0,},
    },
    oldVertical => {
        name_for_deleted => 'vertical',
        name_for_active  => 'vertical',
        filter_tags      => ["adaptive", "vertical"],
        design           => \&copy_design,
        list_for_copy    => [
            qw(
              horizontalAlign
              linksUnderline
              fontSize
              hoverColor
              sitelinksColor
              titleColor
              urlColor
              textColor
              headerBgColor
              siteBgColor
              bgColor
              limit
              )
        ],
    },
    newVertical => {
        name_for_deleted => 'vertical',
        name_for_active  => 'vertical',
        filter_tags      => ["adaptive", "vertical"],
        design           => \&copy_design,
        list_for_copy    => [
            qw(
              horizontalAlign
              bgColor
              textColor
              fontFamily
              fontSize
              limit
              callouts
              )
        ],
    },
    newHorizontal => {
        name_for_deleted => 'horizontal',
        name_for_active  => 'horizontal',
        filter_tags      => ["adaptive", "horizontal"],
        design           => \&copy_design,
        list_for_copy    => [
            qw(
              borderType
              borderRadius
              bgColor
              textColor
              borderColor
              fontFamily
              fontSize
              limit
              callouts
              )
        ],
    },
    pictureSearch3 => {
        name_for_deleted => 'adaptive0418',
        name_for_active  => 'adaptive0418',
        filter_tags      => ["adaptive", "vertical"],
        design           => \&copy_design,
        list_for_copy    => [
            qw(
              limit
              )
        ],
        set_value => {
            width           => 328,
            height          => 181,
            limit           => 1,
            imageWidth      => 160,
            horizontalAlign => \0,
        },
    },
    pictureSearch => {
        name_for_deleted => 'adaptive0418',
        name_for_active  => 'adaptive0418',
        filter_tags      => ["adaptive", "vertical"],
        design           => \&copy_design,
        list_for_copy    => [
            qw(
              horizontalAlign
              borderType
              borderRadius
              bgColor
              borderColor
              fontFamily
              fontSize
              callouts
              )
        ],
        set_value => {limit => 1},
    },

    grid => {
        name_for_deleted => 'adaptive0418',
        name_for_active  => 'adaptive0418',
        filter_tags      => ["adaptive", "vertical"],
        design           => \&copy_design,
        list_for_copy    => [
            qw(
              limit
              noSitelinks
              imagesFirst
              borderRadius
              borderType
              borderColor
              bgColor
              siteBgColor
              textColor
              urlColor
              urlBackgroundColor
              hoverColor
              titleColor
              sitelinksColor
              horizontalAlign
              linksUnderline
              enableAnimation
              callouts
              )
        ],
        set_value => {layout => 'horizontal'},
    },
    posterCarousel => {
        name_for_deleted => 'posterHorizontal',
        name_for_active  => 'posterHorizontal',
        filter_tags      => ["adaptive", "horizontal"],
        design           => \&copy_design,
        list_for_copy    => [
            qw(
              limit
              )
        ],
        set_value => {carousel => \1},
    },
    adaptiveCarousel => {
        name_for_deleted => 'posterHorizontal',
        name_for_active  => 'posterHorizontal',
        filter_tags      => ["adaptive", "horizontal"],
        design           => \&copy_design,
        list_for_copy    => [
            qw(
              limit
              )
        ],
        set_value => {carousel => \1},
    },
};

my %force_number = map {$_ => TRUE} qw(limit);

sub copy_design {
    my ($design, $type) = @_;

    my %new_design = (name => $type->{name_for_active});
    for my $f (@{$type->{list_for_copy}}) {
        $new_design{$f} = $force_number{$f} ? 0 + $design->{$f} : $design->{$f} if exists $design->{$f};
    }
    if ($type->{set_value}) {
        while (my ($f, $v) = each %{$type->{set_value}}) {
            $new_design{$f} = $v;
        }
    }

    return \%new_design;
}

sub change_designs {
    my ($app, $opts) = @_;
    if ($opts->{rollback}) {
        do_rollback_designs($app, $opts);
    } else {
        do_change_designs($app, $opts);
    }
}

sub do_rollback_designs {
    my ($app, $opts) = @_;

    open FH, $opts->{rollback};
    my @delete;
    my @restore;
    my @bk_data;
    my %pages;
    while (my $str = <FH>) {
        $str =~ s/\s+$//;
        my @str = split /\t/, $str;
        if ($str[0] =~ /CHANGE_DESIGN/) {
            push @delete,  $str[3];
            push @restore, $str[2];
            if ($str[1] =~ /R-[AI]-(\d+)-\d+/) {
                $pages{$1} = undef;
            }
        }
        if ($str[0] =~ /CHANGE_BK_DATA/) {
            push @bk_data, [$str[1], $str[2]];
            if ($str[1] =~ /R-[AI]-(\d+)-\d+/) {
                $pages{$1} = undef;
            }
        }
        if ($str[0] =~ /ADD_DESIGN/) {
            push @delete, $str[3];
            if ($str[1] =~ /R-[AI]-(\d+)-\d+/) {
                $pages{$1} = undef;
            }
        }
        if ($str[0] =~ /DELETE_DESIGN/) {
            push @restore, $str[2];
            if ($str[1] =~ /R-[AI]-(\d+)-\d+/) {
                $pages{$1} = undef;
            }
        }
    }
    close FH;
    my $filter_delete = $app->partner_db->filter([id => 'IN' => \\@delete]);
    $app->partner_db->design_templates->edit($filter_delete, {multistate => \1});

    print logstr("DELETE_DESIGN", \@delete);

    my $filter_restore = $app->partner_db->filter([id => 'IN' => \\@restore]);
    $app->partner_db->design_templates->edit($filter_restore, {multistate => \0});
    print logstr("RESTORE_DESIGN", \@restore);

    if (@bk_data) {
        for my $row (@bk_data) {
            my $model = ($row->[0] =~ /^R-A-/ ? '' : 'internal_') . 'context_on_site_rtb';
            my $bk_data = from_json($row->[1]);
            $app->$model->do_action($row->[0], "edit", bk_data => to_json($bk_data, pretty => TRUE));
            print logstr("RESTORE_BK_DATA", $row->[1]);
        }
    }

    if (my @pages = keys %pages) {
        $app->all_pages->mark_pages_for_async_update(page_ids => \@pages);
        print logstr("MARK_TO_RESEND", scalar(@pages));
    } else {
        print logstr("NO_TO_RESEND");
    }
}

sub do_change_designs {
    my ($app, $opts) = @_;

    $opts->{mode} ||= 'replace';

    my $to_change;
    if ($opts->{formats}) {
        $to_change = {};
        for my $format (@{$opts->{formats}}) {
            if ($TO_CHANGE->{$format}) {
                $to_change->{$format} = $TO_CHANGE->{$format};
            } else {
                die "Unknown format name '$format' in formats";
            }
        }
    } else {
        $to_change = $TO_CHANGE;
    }
    # --fix_sv='{"grid":{"height":290}}'
    if ($opts->{fix_sv}) {
        for my $format (keys %{$opts->{fix_sv}}) {
            if ($to_change->{$format}) {
                my $f = $opts->{fix_sv}{$format};
                @{$to_change->{$format}{set_value}}{keys %$f} = values %$f;
            } else {
                die "Unknown format name '$format' in fix_sv";
            }
        }
    }

    my %pages;
    for my $block (@{get_block_list($app, $opts)}) {
        print logstr("START_BLOCK", $block->{public_id});
        for my $design (@{get_design_list($app, $block, $opts)}) {
            if (my $type = $to_change->{$design->{name}}) {
                if ($block->{is_deleted}) {
                    change_name_design($app, $block, $design, $type, $opts);
                } else {
                    $pages{$block->{page_id}} = undef;
                    change_one_design($app, $block, $design, $type, $opts);
                }
            }
        }
        if ($block->{is_custom_bk_data} && $block->{change_bk_data} && !$block->{invalid_bk_data}) {
            my $bk_data     = $block->{bk_data};
            my $old_bk_data = clone($bk_data);
            for my $c (@{$block->{change_bk_data}}) {
                my $data = clone($bk_data->{RtbDesign}{$c->{old}});
                if ($MODES{$opts->{mode}}{delete}) {
                    delete $bk_data->{RtbDesign}{$c->{old}};
                }
                if ($MODES{$opts->{mode}}{add}) {
                    $data->{design} = $c->{data};
                    $bk_data->{RtbDesign}{$c->{new}} = $data;
                }
            }
            my $model = $block->{model};
            my @gm_data;
            if ($opts->{clear_gm}) {
                @gm_data = (is_custom_bk_data => 0);
            } else {
                @gm_data = (bk_data => to_json($bk_data, pretty => TRUE));
            }
            try {
                $app->$model->do_action($block->{public_id}, "edit", @gm_data);
                print logstr("CHANGE_BK_DATA", $block->{public_id}, $old_bk_data, $bk_data->{RtbDesign});
            }
            catch {
                my ($e) = @_;
                print logstr("FAIL_BK_DATA", $block->{public_id}, $e->message, $bk_data->{RtbDesign});
            };
        }
    }

    if (my @pages = keys %pages) {
        $app->all_pages->mark_pages_for_async_update(page_ids => \@pages);
        print logstr("MARK_TO_RESEND", scalar(@pages));
    } else {
        print logstr("NO_TO_RESEND");
    }
}

sub get_block_list {
    my ($app, $opts) = @_;

    my @list = map {"R-A-$_->{page_id}-$_->{block_id}"} @{$opts->{list}};
    my $list = $app->context_on_site_rtb->get_all(
        fields => [qw(public_id page_id id login owner_id is_deleted is_custom_bk_data bk_data)],
        filter => {public_id => \@list},
    );

    for my $row (@$list) {
        $row->{model}  = 'context_on_site_rtb';
        $row->{prefix} = 'R-A-';
    }

    @list = map {"R-I-$_->{page_id}-$_->{block_id}"} @{$opts->{list}};
    my $list2 = $app->internal_context_on_site_rtb->get_all(
        fields => [qw(public_id page_id id login owner_id is_deleted is_custom_bk_data bk_data)],
        filter => {public_id => \@list},
    );
    for my $row (@$list2) {
        $row->{model}  = 'internal_context_on_site_rtb';
        $row->{prefix} = 'R-I-';
        push @$list, $row;
    }

    return $list;
}

sub get_design_list {
    my ($app, $block, $opts) = @_;
    my $list = $app->partner_db->design_templates->get_all(
        fields => [qw(id page_id block_id opts caption)],
        filter => [
            AND => [
                [page_id    => '=' => \$block->{page_id}],
                [block_id   => '=' => \$block->{id}],
                [type       => '=' => \'tga'],
                [multistate => '=' => \0],
            ]
        ]
    );
    my $gm_designs;
    if ($block->{is_custom_bk_data}) {
        $gm_designs = from_json($block->{bk_data})->{RtbDesign};
    }
    for my $row (@$list) {
        $row->{opts} = from_json($row->{opts});
        if ($gm_designs && $gm_designs->{$row->{id}}) {
            $row->{opts}{design_settings} = $gm_designs->{$row->{id}}{design};
        }
        $row->{name} = $row->{opts}{design_settings}{name} // '';
    }
    return $list;
}

sub change_name_design {
    my ($app, $block, $design, $type, $opts) = @_;

    my @log = ($block->{prefix} . "$design->{page_id}-$design->{block_id}", $design->{id});
    try {
        my $opts = $design->{opts};
        $opts->{design_settings}{name} = $type->{name_for_deleted};
        $app->partner_db->design_templates->edit($design->{id}, {opts => to_json($opts)});
        print logstr("RENAME_DESIGN", @log);
    }
    catch {
        my ($e) = @_;
        print logstr("RENAME_FAIL", @log, $e->message);
    };
}

sub change_one_design {
    my ($app, $block, $design, $type, $opts) = @_;

    my @log = ($block->{prefix} . "$design->{page_id}-$design->{block_id}", $design->{id});
    try {
        my %new_design;
        if ($block->{is_custom_bk_data}) {
            unless (ref $block->{bk_data}) {
                $block->{bk_data} = from_json($block->{bk_data});
            }
            my $old_settings = $block->{bk_data}{RtbDesign}{$design->{id}}{design};
            %new_design = make_design($old_settings, $type);
            my %for_bk = %{$new_design{design_settings}};
            $for_bk{blockId} = $old_settings->{blockId};
            push @{$block->{change_bk_data}},
              {
                old  => $design->{id},
                data => \%for_bk,
              };
        } else {
            %new_design = make_design($design->{opts}{design_settings}, $type);
        }
        my %params = (
            page_id  => $design->{page_id},
            block_id => $design->{block_id},
            caption  => $design->{caption},
            %new_design,
        );
        if ($type->{new_type}) {
            $params{type} = $type->{new_type};
        }

        my $new_id = '';
        if ($MODES{$opts->{mode}}{add}) {
            $new_id = $app->design_templates->add(%params);
        }
        if ($MODES{$opts->{mode}}{delete}) {
            $app->design_templates->do_action($design->{id}, 'delete');
        }
        print logstr($MODES{$opts->{mode}}{log}, @log, $new_id);

        if ($block->{is_custom_bk_data}) {
            $block->{change_bk_data}[-1]{new} = $new_id;
        }
    }
    catch {
        my ($e) = @_;
        $block->{invalid_bk_data} = TRUE;
        print logstr("CHANGE_FAIL", @log, $e->message);
    };
}

sub make_design {
    my ($design, $type) = @_;

    return (
        filter_tags             => $type->{filter_tags},
        design_settings         => $type->{design}($design, $type),
        is_custom_format_direct => $type->{is_custom_format_direct} // 0,
    );
}

1;
