package Utils::Oneshots::ChangeDesignRowToNative;

use qbit;

my $to_change = {
    row => {
        css      => \&row_css,
        template => \&row_template,
    },
    newRow => {
        css      => \&newrow_css,
        template => \&newrow_template,
    },
};

my $user_opts    = 'allowed_design_auction_native_only';
my $user_feature = 'design_auction_native';

sub change_designs {
    my ($app, $opts) = @_;
    if ($opts->{rollback}) {
        do_rollback_designs($app, $opts);
    } elsif ($opts->{update}) {
        do_update_designs($app, $opts);
    } else {
        do_change_designs($app, $opts);
    }
}

sub do_update_designs {
    my ($app, $opts) = @_;

    open FH, $opts->{update};
    my @update;
    while (my $str = <FH>) {
        $str =~ s/\s+$//;
        my @str = split /\t/, $str;
        if ($str[0] =~ /(\d+-\d+-\d+ \d+:\d+:\d+) - CHANGE_DESIGN/) {
            push @update, [$str[3], $1];
        }
    }
    close FH;

    my %pages;
    for my $row (@update) {
        my $has = $app->partner_db->design_templates_action_log->get_all(
            fields => ['id'],
            filter => [AND => [[elem_id => '=' => \$row->[0]], [action => '=' => \'edit'], [dt => '>' => \$row->[1]],]]
        );
        if (@$has) {
            print logstr("SKIP_DESIGN", $row->[0]);
        } elsif (my $design = $app->partner_db->design_templates->get($row->[0], fields => ['opts', 'page_id'])) {
            my $opts = from_json($design->{opts});
            $opts->{design_settings}{css} =~
              s/font-family: "Times New Roman";/font-family: Arial, Helvetica, sans-serif;/g;
            $opts->{design_settings}{css} =~
              s/font-family: "Times new Roman";/font-family: Arial, Helvetica, sans-serif;/g;
            $opts->{design_settings}{css} =~
s/font-family: "Times New Roman", Helvetica, Arial, sans-serif !important;/font-family: Arial, Helvetica, sans-serif;/g;

            try {
                $app->partner_db->design_templates->edit($row->[0], {opts => to_json($opts)});
                print logstr("UPDATE_DESIGN", $row->[0]);
                $pages{$design->{page_id}} = undef;
            }
            catch {
                my ($e) = @_;
                print logstr("FAIL_DESIGN", $row->[0], $e->message);
            };
        } else {
            print logstr("NO_DESIGN", $row->[0]);
        }
    }

    if (my @pages = sort keys %pages) {
        $app->all_pages->mark_pages_for_async_update(page_ids => \@pages);
        print logstr("MARK_TO_RESEND", scalar(@pages));
    } else {
        print logstr("NO_TO_RESEND");
    }
}

sub do_rollback_designs {
    my ($app, $opts) = @_;

    open FH, $opts->{rollback};
    my @delete;
    my @restore;
    my %pages;
    while (my $str = <FH>) {
        $str =~ s/\s+$//;
        my @str = split /\t/, $str;
        if ($str[0] =~ /CHANGE_DESIGN/) {
            push @delete,  $str[3];
            push @restore, $str[2];
            if ($str[1] =~ /R-A-(\d+)-\d+/) {
                $pages{$1} = undef;
            }
        }
    }
    close FH;
    my $filter_delete = $app->partner_db->filter([id => 'IN' => \\@delete]);
    $app->partner_db->design_templates->edit($filter_delete, {multistate => \1});

    print logstr("DELETE_DESIGN", \@delete);

    my $filter_restore = $app->partner_db->filter([id => 'IN' => \\@restore]);
    $app->partner_db->design_templates->edit($filter_restore, {multistate => \0});
    print logstr("RESTORE_DESIGN", \@restore);

    if (my @pages = keys %pages) {
        $app->all_pages->mark_pages_for_async_update(page_ids => \@pages);
        print logstr("MARK_TO_RESEND", scalar(@pages));
    } else {
        print logstr("NO_TO_RESEND");
    }
}

sub do_change_designs {
    my ($app, $opts) = @_;
    my %pages;
    my %logins;
    my %login_to_id;
    for my $block (@{get_block_list($app, $opts)}) {
        $login_to_id{$block->{login}} = $block->{owner_id};

        my $native_only = 1;
        for my $design (@{get_design_list($app, $block, $opts)}) {
            if (my $type = $to_change->{$design->{name}}) {
                if ($block->{is_deleted}) {
                    change_name_design($app, $design, $type, $opts);
                } else {
                    $pages{$block->{page_id}} = undef;
                    change_one_design($app, $design, $type, $opts);
                }
            } elsif (!$block->{is_deleted}) {
                $native_only = 0;
            }
        }
        $logins{$block->{login}} ||= $native_only;
    }
    for my $login (keys %logins) {
        try {
            $app->user_features->add($login_to_id{$login}, $user_feature);
            print logstr("ADD_FEATURE", $login);
        }
        catch {
            my ($e) = @_;
            print logstr("SKIP_FEATURE", $login, $e->message);
        };
        if ($logins{$login}) {
            try {
                $app->users->do_action($login_to_id{$login}, 'edit', $user_opts => TRUE);
                print logstr("ON_OPTION", $login);
            }
            catch {
                my ($e) = @_;
                print logstr("FAIL_OPTION", $login, $e->message);
            };
        } else {
            print logstr("SKIP_OPTION", $login);
        }
    }
    if (my @pages = keys %pages) {
        $app->all_pages->mark_pages_for_async_update(page_ids => \@pages);
        print logstr("MARK_TO_RESEND", scalar(@pages));
    } else {
        print logstr("NO_TO_RESEND");
    }
}

sub get_block_list {
    my ($app, $opts) = @_;
    my @list = map {"R-A-$_->{page_id}-$_->{block_id}"} @{$opts->{list}};
    my $list = $app->context_on_site_rtb->get_all(
        fields => [qw(page_id id login owner_id is_deleted)],
        filter => {public_id => \@list},
    );
    return $list;
}

sub get_design_list {
    my ($app, $block, $opts) = @_;
    my $list = $app->partner_db->design_templates->get_all(
        fields => [qw(id page_id block_id opts caption)],
        filter => [
            AND => [
                [page_id    => '=' => \$block->{page_id}],
                [block_id   => '=' => \$block->{id}],
                [type       => '=' => \'tga'],
                [multistate => '=' => \0],
            ]
        ]
    );
    for my $row (@$list) {
        $row->{opts} = from_json($row->{opts});
        $row->{name} = $row->{opts}{design_settings}{name} // '';
    }
    return $list;
}

sub change_name_design {
    my ($app, $design, $type, $opts) = @_;

    my @log = ("R-A-$design->{page_id}-$design->{block_id}", $design->{id});
    try {
        my $opts = $design->{opts};
        $opts->{design_settings}{name} = 'adaptive0418';
        $app->partner_db->design_templates->edit($design->{id}, {opts => to_json($opts)});
        print logstr("RENAME_DESIGN", @log);
    }
    catch {
        my ($e) = @_;
        print logstr("RENAME_FAIL", @log, $e->message);
    };
}

sub change_one_design {
    my ($app, $design, $type, $opts) = @_;

    my @log = ("R-A-$design->{page_id}-$design->{block_id}", $design->{id});
    try {
        my $new_id = $app->design_templates->add(
            page_id  => $design->{page_id},
            block_id => $design->{block_id},
            type     => 'native',
            caption  => $design->{caption},
            make_design($design->{opts}{design_settings}, $type),
        );
        $app->design_templates->do_action($design->{id}, 'delete');
        print logstr("CHANGE_DESIGN", @log, $new_id);
    }
    catch {
        my ($e) = @_;
        print logstr("CHANGE_FAIL", @log, $e->message);
    };
}

sub make_design {
    my ($design, $subs) = @_;

    return (
        filter_tags     => undef,
        design_settings => {
            grid_rows    => 1,
            grid_columns => 1,
            template     => fix_utf($subs->{template}($design)),
            css          => fix_utf($subs->{css}($design)),
        },
        is_custom_format_direct => 0,
    );
}

sub newrow_css {
    my ($design) = @_;

    return q|
.wrapper {
  position: relative;|
      . ($design->{bgColor} ? "\nbackground-color: #$design->{bgColor};" : '')
      . ($design->{borderRadius} ? "\nborder-radius: 3px;" : '')
      . (
        $design->{borderType} && $design->{borderType} eq 'block'
        ? "\nborder: 1px solid " . ($design->{borderColor} ? "#$design->{borderColor}" : 'rgb(221, 221, 221)') . ";"
        : ''
      )
      . q|
}

.grid-row:first-child {
  display: block;
}

.grid-item {
  min-width: 0;
}

.unit-container {
  display: flex;
  padding: 4px;
  white-space: nowrap;
  align-items: center;
  font-family: Arial, Helvetica, sans-serif;
}

.t {
  color: #fff;
  font-size: 19px;
  line-height: 30px;
  letter-spacing: 20px;
  text-transform: uppercase;
  margin-right: 10px;
  width: 30px;
  height: 30px;
  border-radius: 50%;
  background-color: rgba(0, 0, 0, 0.1);
  box-shadow: inset 0 0 0 1px rgba(0, 0, 0, 0.1);
  flex-shrink: 0;
  white-space: nowrap;
  overflow: hidden;
}

.tt {
  font-family: YS Text, Helvetica, Arial, sans-serif !important;
  position: relative;
  top: 1px;
  left: 11px;
  transform: scale(1.2);
}

.title,
.desc {
  flex-shrink: 1;
  min-width: 0;
}

.title .ya-unit-title,
.desc .ya-unit-desc {
  max-width: 100%;
  overflow: hidden;
  text-overflow: ellipsis;
}

.title {
  line-height: 30px;
  color: #| . ($design->{titleColor} || '00f') . q|;
  margin-right: 5px;
  font-family: inherit !important;
  text-decoration-line: |
      . (
        exists $design->{linksUnderline}
        ? ($design->{linksUnderline} ? $design->{linksUnderline} : 'none')
        : 'underline'
      )
      . q|;
  font-weight: 700;
}
| . (
        $design->{hoverColor}
        ? "

.title:hover {
  color: #$design->{hoverColor};
}
"
        : ''
    )
      . q|
.desc {
  flex-grow: 1;
  flex-basis: 30%;
  line-height: 30px;
  margin: 0;
  color: #| . ($design->{textColor} || get_contrast_color($design->{bgColor}, '000')) . q|;
  margin-right: 5px;
}

.ya-unit-age:not(:empty) {
  padding: 1px 3px;
  border: 1px solid #ccc;
  border-radius: 8px;
  color: |
      . ($design->{textColor} ? "#$design->{textColor}" : to_rgba(get_contrast_color($design->{bgColor}, '000'), 0.7))
      . q|;
  font-size: 13px;
  line-heigh: 18px;
  height: 16px;
  margin-right: 5px;
}

.warning {
  margin-right: 5px;
  min-width: 189px;
  height: 14px;
}

.warning .unit-image {
  display: none;
}

.warning > div {
  bottom: 50%;
  transform: translateY(50%);
  color: #000;
  background-color: rgba(0, 0, 0, 0.1);
  box-shadow: inset 0 0 0 1px rgba(0, 0, 0, 0.1);
}

.warning > div > div {
  text-shadow: none;
  padding: 2px 7px !important;
}

.warning > div > div > div {
  text-shadow: none;
  font-family: Arial, Helvetica, sans-serif;
  font-size: 12px;
}

.unit-wrapper:not(.unit-with-warning) .warning {
  display: none;
}

.button {
  margin-right: 46px;
}

.button-inner {
  padding: 0 16px;
  height: 24px;
  font-size: 16px;
  line-height: 24px;
  border-radius: 3px;
  box-sizing: border-box;
  color: #| . ($design->{textColor} || get_contrast_color($design->{siteBgColor} // $design->{bgColor}, '000')) . q|;
  background-color: |
      . (
          $design->{siteBgColor} ? "#$design->{siteBgColor}"
        : $design->{bgColor}     ? "#$design->{bgColor}"
        : 'rgba(255, 255, 255, 0.97)'
      )
      . q|;
  box-shadow: inset 0 0 0 1px rgba(228, 228, 228, 0.97);
}

.button-inner:hover {
  color: #00f;
  box-shadow: inset 0 0 0 1px #00f;
}

.direct {
  font-size: 11px;
  position: absolute;
  z-index: 10;
  right: 25px;
  top: 50%;
  margin-top: -10px;
  width: 20px;
  height: 20px;
  text-align: center;
  line-height: 20px;
  text-decoration: none;
  color: #| . ($design->{textColor} || get_contrast_color($design->{bgColor}, '000')) . q|;
  opacity: 0.9;
}

.direct:hover {
  opacity: 1;
}

.ya-ad-close {
  top: 50%;
  margin-top: -10px;
  opacity: 0.9;
  background: none;
  padding: 6px;
}

.ya-ad-close:hover {
  opacity: 1;
}

.ya-adtune-feedback__messages {
  max-width: 400px;
}

.ya-adtune-feedback {
  font-size: 11px;
}

.unit-wrapper:not(.unit-with-warning) .warning {
  display: none;
}

.grid-row:first-child .unit-with-warning .warning {
  font-size: 12px;
  line-height: 14px;
  position: static;
  flex-basis: 20%;
  overflow: hidden;
  padding: 1px 7px;
  white-space: nowrap;
  color: #| . (get_contrast_color(get_contrast_color($design->{bgColor}, '000')), 'fff') . q|;
  text-shadow: none;
  background: | . (to_rgba(get_contrast_color($design->{bgColor}, '000'), 0.3)) . q|;
  min-width: 180px;
  margin-right: 5px;
}

.grid-row:first-child .unit-warning {
  display: inline-block;
  min-width: 100%;
  animation: 7s 0.3s 1 warning-content;
}

.warning__wrap {
  display: block;
  max-width: 100%;
  animation: 7s 0.3s 1 warning-wrap;
}

.warning__wrap,
.grid-row:first-child .unit-warning {
  transition: transform 1s;
}

.warning__right,
.warning__center {
  position: absolute;
  top: 0;
  bottom: 0;
  width: 30%;
  z-index: 10;
  animation: 8.3s hide-controls;
}

.warning__right {
  right: 0;
}

.warning__center {
  width: auto;
  left: 30%;
  right: 30%;
}

@keyframes warning-content {
  0% {
    transform: translateX(0);
  }

  35% {
    transform: translateX(-100%);
  }

  65% {
    transform: translateX(-100%);
  }

  100% {
    transform: translateX(0);
  }
}

@keyframes warning-wrap {
  0% {
    transform: translateX(0);
  }

  35% {
    transform: translateX(100%);
  }

  65% {
    transform: translateX(100%);
  }

  100% {
    transform: translateX(0);
  }
}

@keyframes hide-controls {
  0% {
    transform: translateY(0);
  }

  5% {
    transform: translateY(100%);
  }

  95% {
    transform: translateY(100%);
  }

  100% {
    transform: translateY(0);
  }
}

.warning__right:hover ~ .warning__wrap {
  transform: translateX(100%);
}

.warning__right:hover ~ .warning__wrap .unit-warning {
  transform: translateX(-100%);
}

.warning__center:hover ~ .warning__wrap {
  transform: translateX(50%);
}

.warning__center:hover ~ .warning__wrap .unit-warning {
  transform: translateX(-50%);
}
|;
}

sub newrow_template {
    my ($design) = @_;

    return q|
<div class="wrapper">
    <ya-units-grid cols="1" rows="2">
        <div class="t">
            <ya-unit-title class="tt" />
        </div>
        <div class="title">
            <ya-unit-title />
        </div>
        <div class="desc">
            <ya-unit-desc class="desc" />
        </div>
        <div class="warning">
         <i class="warning__center"></i>
         <i class="warning__right"></i>
         <span class="warning__wrap">
             <ya-unit-warning class="unit-warning" />
         </span>
     </div>
        <ya-unit-age />
        <div class="button">
            <div class="button-inner">
                Перейти
            </div>
        </div>
        <ya-unit-close class="close" svg="data:image/svg+xml,%3Csvg xmlns='http://www.w3.org/2000/svg' width='8px' height='8px' viewBox='0 0 14 14'%3E%3Cpolygon points='8.28616426 7.02081528 13.6638974 12.3985484 12.3985484 13.6638974 7.02081528 8.28616426 1.64308213 13.6638974 0.377733152 12.3985484 5.7554663 7.02081528 0.377733152 1.64308213 1.64308213 0.377733152 7.02081528 5.7554663 12.3985484 0.377733152 13.6638974 1.64308213'%3E%3C/polygon%3E%3C/svg%3E" />
    </ya-units-grid>
    <a class="direct" href="https://direct.yandex.ru/?partner" target="_blank">₽</a>
</div>
|;
}

sub row_template {
    my ($design) = @_;

    return q|
<div class="wrapper">
    <ya-units-grid cols="1" rows="2">

        <div class="title">
            <ya-unit-title />
        </div>
        <div class="desc">
            <ya-unit-desc class="desc" />
        </div>
          <div class="warning">
         <i class="warning__center"></i>
         <i class="warning__right"></i>
         <span class="warning__wrap">
             <ya-unit-warning class="unit-warning" />
         </span>
     </div>
        <ya-unit-age />

        <ya-unit-close class="close" svg="data:image/svg+xml,%3Csvg xmlns='http://www.w3.org/2000/svg' width='8px' height='8px' viewBox='0 0 14 14'%3E%3Cpolygon points='8.28616426 7.02081528 13.6638974 12.3985484 12.3985484 13.6638974 7.02081528 8.28616426 1.64308213 13.6638974 0.377733152 12.3985484 5.7554663 7.02081528 0.377733152 1.64308213 1.64308213 0.377733152 7.02081528 5.7554663 12.3985484 0.377733152 13.6638974 1.64308213'%3E%3C/polygon%3E%3C/svg%3E" />
    </ya-units-grid>
    <a class="direct" href="https://direct.yandex.ru/?partner" target="_blank">₽</a>
</div>
|;
}

sub row_css {
    my ($design) = @_;
    return q|
.wrapper {
    position: relative;|
      . ($design->{bgColor} ? "\nbackground-color: #$design->{bgColor};" : '')
      . ($design->{borderRadius} ? "\nborder-radius: 3px;" : '')
      . (
        $design->{borderType} && $design->{borderType} eq 'block'
        ? "\nborder: 1px solid " . ($design->{borderColor} ? "#$design->{borderColor}" : 'rgb(221, 221, 221)') . ";"
        : ''
      )
      . q|
}

.grid-row:first-child {
    display: block;
}

.grid-item {
    min-width: 0;
}

.unit-container {
    display: flex;
    white-space: nowrap;
    align-items: center;
    font-family: Arial, Helvetica, sans-serif;
}

.title, .desc {
    flex-shrink: 1;
    min-width: 0;
}

.title .ya-unit-title {
    max-width: 100%;
    overflow: hidden;
    text-overflow: ellipsis;
    font-family: Arial, Helvetica, sans-serif;
    font-size: 16px;
    font-weight: 700;
    text-decoration: none;
}

.desc .ya-unit-desc {
    max-width: 100%;
    overflow: hidden;
    text-overflow: ellipsis;
    line-height: 20px;
}

.title {
    line-height: normal;
    font-size: 12.8px;
    color: #| . ($design->{titleColor} || '00f') . q|;
    margin-right: 5px;
    font-family: inherit !important;
    text-decoration-line: |
      . (
        exists $design->{linksUnderline}
        ? ($design->{linksUnderline} ? $design->{linksUnderline} : 'none')
        : 'underline'
      )
      . q|;
    font-weight: 700;
}
| . (
        $design->{hoverColor}
        ? "

.title:hover {
  color: #$design->{hoverColor};
}
"
        : ''
    )
      . q|
.desc {
    flex-grow: 1;
    flex-basis: 30%;
    line-height: normal;
    margin: 0;
    color: #| . ($design->{textColor} || get_contrast_color($design->{bgColor}, '000')) . q|;
    margin-right: 5px;
    min-height: 20px !important;
    font-family: Arial, Helvetica, sans-serif;
    font-size: 16px;
}

.ya-unit-age:not(:empty) {
    padding: 1px 3px;
    border: 1px solid #ccc;
    border-radius: 8px;
    color: |
      . ($design->{textColor} ? "#$design->{textColor}" : to_rgba(get_contrast_color($design->{bgColor}, '000'), 0.7))
      . q|;
    font-size: 13px;
    line-height: 18px;
    height: 15px;
    margin-right: 18px;
}

.direct {
    font-size: 11px;
    position: absolute;
    z-index: 10;
    right: 43px;
    top: 50%;
    margin-top: -10px;
    width: 20px;
    height: 20px;
    text-align: center;
    line-height: 20px;
    text-decoration: none;
    color: #| . ($design->{textColor} || get_contrast_color($design->{bgColor}, '000')) . q|;
    opacity: .9;
}

.direct:hover {
    opacity: 1;
}

.ya-ad-close {
    top: 50%;
    margin-top: -10px;
    opacity: .9;
    background: none;
    padding: 6px;
}

.ya-ad-close:hover {
    opacity: 1;
}

.ya-adtune-feedback__messages {
  max-width: 400px;
}

.ya-adtune-feedback {
  font-size: 11px;
}

.ya-adtune-feedback__messages-row-size-2 {
  font-size: 12px;
  padding: 0;
}

.unit-wrapper:not(.unit-with-warning) .warning {
    display: none;
}

.grid-row:first-child .unit-with-warning .warning {
    font-size: 11px;
    line-height: 14px;
    position: static;
    flex-basis: 20%;
    overflow: hidden;
    padding: 1px 7px;
    white-space: nowrap;
    color: #| . (get_contrast_color(get_contrast_color($design->{bgColor}, '000')), 'fff') . q|;
    text-shadow: none;
    background: | . (to_rgba(get_contrast_color($design->{bgColor}, '000'), 0.3)) . q|;
    min-width: 180px;
    margin-right: 60px;
}

.grid-row:first-child .unit-warning {
    display: inline-block;
    min-width: 100%;
    animation: 7s 0.3s 1 warning-content;
}

.warning__wrap {
    display: block;
    max-width: 100%;
    animation: 7s 0.3s 1 warning-wrap;
}

.warning__wrap,
.grid-row:first-child .unit-warning {
    transition: transform 1s;
}

.warning__right,
.warning__center {
    position: absolute;
    top: 0;
    bottom: 0;
    width: 30%;
    z-index: 10;
    animation: 8.3s hide-controls;
}

.warning__right {
    right: 0;
}

.warning__center {
    width: auto;
    left: 30%;
    right: 30%;
}

@keyframes warning-content {
    0% {
        transform: translateX(0);
    }

    35% {
        transform: translateX(-100%);
    }

    65% {
        transform: translateX(-100%);
    }

    100% {
        transform: translateX(0);
    }
}

@keyframes warning-wrap {
    0% {
        transform: translateX(0);
    }

    35% {
        transform: translateX(100%);
    }

    65% {
        transform: translateX(100%);
    }

    100% {
        transform: translateX(0);
    }
}

@keyframes hide-controls {
    0% {
        transform: translateY(0);
    }

    5% {
        transform: translateY(100%);
    }

    95% {
        transform: translateY(100%);
    }

    100% {
        transform: translateY(0);
    }
}

.warning__right:hover ~ .warning__wrap {
    transform: translateX(100%);
}

.warning__right:hover ~ .warning__wrap .unit-warning {
    transform: translateX(-100%);
}

.warning__center:hover ~ .warning__wrap {
    transform: translateX(50%);
}

.warning__center:hover ~ .warning__wrap .unit-warning {
    transform: translateX(-50%);
}
|;
}

sub get_contrast_color {
    my ($rgb, $def) = @_;

    return $def unless $rgb;

    my @v = split //, $rgb;
    if (@v == 6) {
        @v = ($v[0] . $v[1], $v[2] . $v[3], $v[4] . $v[5]);
    } else {
        @v = ($v[0] . $v[0], $v[1] . $v[1], $v[2] . $v[2]);
    }
    my $v = 0.299 * hex($v[0]) + 0.587 * hex($v[1]) + 0.114 * hex($v[2]);

    return $v < 127 ? 'fff' : '000';
}

sub to_rgba {
    my ($rgb, $v) = @_;
    my @v = split //, $rgb;
    return 'rgba(' . join(',', map {hex($_ . $_)} @v) . ",$v)";
}

1;
