package Utils::Oneshots::FixFilterTagsOnTurbo;
use qbit;

use Utils::PublicID;
use File::Slurp qw(read_file);

my @models_list = qw(internal_context_on_site_rtb context_on_site_rtb);
# echo "select campaign_id id from context_on_site_rtb where site_version = 'turbo' and multistate & 2" | myprod > out.txt
# wc -l out.txt
# 110223 out.txt

my %valid_tags = map {$_ => TRUE} ('in-content', 'floor-ad', 'above-header', 'recommendation-feed');

# https://st.yandex-team.ru/PI-21478#5f5aa91ad86f3b052dc0333b
# Если на блоке есть хотя бы один дизайн размеченный правильно - размечаем все остальные дизайны
# точно так же как первый попавшийся дизайн с правильной разметкой

sub main {
    my ($app, $opts) = @_;

    my %pages;
    my $count = 0;
    for my $model (@models_list) {
        print logstr('START_MODEL', $model);
        my $block_list = $app->$model->get_all(
            fields => [qw(page_id id)],
            filter => {site_version => 'turbo', multistate => 'not deleted'},
        );
        for my $block (@$block_list) {
            my $valid;
            my @to_fix;
            for my $design (get_designs($app, $block)) {
                my @orig = @{$design->{filter_tags} // []};
                my @new = grep {$valid_tags{$_}} @orig;
                unless (@new) {
                    push @to_fix, $design;
                    next;
                }
                # запомнили правильные тэги
                $valid //= \@new;
                next if @new == @orig;
                unless ($opts->{dry_run}) {
                    $app->design_templates->do_action($design->{id}, 'edit', filter_tags => \@new);
                }
                print logstr('UPDATE', $model, $design->{id}, $design->{page_id}, $design->{block_id}, \@orig, \@new);
                $count++;
                $pages{$block->{page_id}} = TRUE;
            }
            if (@to_fix) {
                # применяем запомненые тэги
                if ($valid) {
                    for my $design (@to_fix) {
                        my @orig = @{$design->{filter_tags} // []};
                        unless ($opts->{dry_run}) {
                            $app->design_templates->do_action($design->{id}, 'edit', filter_tags => $valid);
                        }
                        print logstr('UPDATE', $model, $design->{id}, $design->{page_id}, $design->{block_id}, \@orig,
                            $valid);
                        $count++;
                    }
                } else {
                    for my $design (@to_fix) {
                        my @orig = @{$design->{filter_tags} // []};
                        print logstr('FAIL', $model, $design->{id}, $design->{page_id}, $design->{block_id}, \@orig);
                    }
                }
            }
        }
        print logstr('DONE_MODEL', $model);
    }
    print logstr('MAKE', $count);
}

sub get_designs {
    my ($app, $block) = @_;

    return @{
        $app->design_templates->get_all(
            fields => [qw(id page_id block_id filter_tags)],
            filter => {
                page_id    => $block->{page_id},
                block_id   => $block->{id},
                type       => 'tga',
                multistate => 'not deleted'
            }
        )
      };
}
1;
