package Utils::Oneshots::FixNativeTemplate;

use qbit;

=head1 исправление по логике PI-25162

Если в шаблоне нет элемента ya-unit-kebab (ошибка валидатора)
    Если в шаблоне есть тег ya-unit-close , то заменить его на <ya-unit-kebab />
    если в шаблоне нет ни ya-unit-close ни ya-unit-kebab , то добавить <ya-unit-kebab /> прямо перед закрывающим тегом </ya-units-grid> или </ya-units-slider>
Если в шаблоне нет элемента ya-unit-category (ошибка валидатора)
    Для РТБ-блоков и нативных блоков
        добавить тег <ya-unit-category /> (надпись Реклама с возрастной меткой) сразу после открывающего тега <ya-units-grid> или <ya-units-slider>
    Для рекомендательного виджета
        добавить тег <ya-unit-category ad-only /> (надпись Реклама с возрастной меткой) сразу после открывающего тега <ya-units-grid> или <ya-units-slider>
Если в шаблоне есть тег ya-unit-age (проверить на стороне ПИ)
    удалить тег ya-units-age (может быть с закрывающим: <ya-unit-age /> или <ya-unit-age><ya-unit-age /> )

=cut

sub fix_kebab {
    my ($template) = @_;

    my $has_kebab = $template =~ /ya-unit-kebab/;
    if ($has_kebab) {
        $template =~ s/<ya-unit-close[^>]*>//;
        $template =~ s/<\/ya-unit-close>//;
    } elsif ($template =~ /<\/ya-unit-close>/) {
        $template =~ s/<ya-unit-close[^>]*>.*?<\/ya-unit-close>/<ya-unit-kebab \/>/;
    } elsif ($template =~ /<ya-unit-close/) {
        $template =~ s/<ya-unit-close[^>]*>/<ya-unit-kebab \/>/;
    } else {
        $template =~ s/(<\/ya-units-(?:grid|slider)>)/<ya-unit-kebab \/>$1/;
    }

    return $template;
}

sub fix_category {
    my ($template, $is_content) = @_;

    my $filler = $is_content ? ' ad-only' : '';
    unless ($template =~ /ya-unit-category/) {
        $template =~
          s/(<\/ya-units-(?:grid|slider)>)/\n<ya-unit-category class="ya-unit-category_default"$filler \/>\n$1/;
    }
    return $template;
}

sub fix_age {
    my ($template) = @_;

    $template =~ s/<\/?ya-unit-age[^>]*\/?>//g;

    return $template;
}

1;
