package Utils::Oneshots::MigrationAdfoxScenaries;

=encoding UTF-8

=head1 DESCRIPTION

Модуль переносит блоки адфокса в специальные сценарии

=head1 USAGE

  perl -Ilib migrations/after_release/PI-22075_adfox_block_vmap.pl

=head1 OPTIONS


=cut

use qbit;
use Utils::PublicID;
use File::Slurp qw(read_file);

sub main {
    my ($app, $opts) = @_;

    _add_scenaries($app, $opts);
}

sub _get_adfox_block {
    my ($app, $opts) = @_;

    my $instream_table = $app->partner_db->video_an_site_instream;
    my $sql            = $app->partner_db->query->select(
        table  => $instream_table,
        fields => [qw(page_id id vmap_id)],
        filter => ['adfox_block', '=', \1]
      )->join(
        table   => $app->partner_db->video_scenaries,
        fields  => [],
        join_on => [AND => [['id', '=', {vmap_id => $instream_table}], ['page_id', '=', {page_id => $instream_table}]]],
        filter => [{ifnull => [{json_unquote => [{json_extract => ['opts', \'$.for_adfox']}]}, \0]}, '=', \0],
      );

    my %by_page;
    for my $row (@{$sql->get_all()}) {
        push @{$by_page{$row->{page_id}}}, $row;
    }

    return \%by_page;
}

sub _add_scenaries {
    my ($app, $opts) = @_;

    my $block_by_page = _get_adfox_block($app, $opts);

    print logstr("NO_SUCH_BLOCKS") unless %$block_by_page;

    my %check_vmap;
    my %pages;
    for my $page_id (keys %$block_by_page) {
        my $vmap_id;
        try {
            $vmap_id = $app->video_scenaries->get_or_create_default_scenario($page_id, 1);
            print logstr("CREATE_VMAP", $page_id, $vmap_id);
        }
        catch {
            my ($e) = @_;
            print logstr("FAIL_GET_VMAP", $page_id, $e->message);
        };
        next unless $vmap_id;

        for my $row (@{$block_by_page->{$page_id}}) {
            try {
                $app->partner_db->video_an_site_instream->edit($row, {vmap_id => $vmap_id});
                $check_vmap{$page_id}{$row->{vmap_id}} = undef;
                $pages{$page_id} = undef;
                print logstr("UPDATE_BLOCK", $vmap_id, $row);
            }
            catch {
                my ($e) = @_;
                print logstr("FAIL_BLOCK", $vmap_id, $row, $e->message);
            };
        }
    }

    for my $page_id (keys %check_vmap) {
        for my $vmap_id (keys %{$check_vmap{$page_id}}) {
            my $list = $app->partner_db->video_an_site_instream->get_all(
                fields => {cnt => {count => ['id']}},
                filter => [AND => [['page_id', '=', \$page_id], ['vmap_id', '=', \$vmap_id]]],
            );
            # удаляем сценарии на которых совсем нет блоков
            unless ($list && @$list && $list->[0]{cnt} > 0) {
                try {
                    $app->video_scenaries->do_action({page_id => $page_id, id => $vmap_id}, 'delete');
                    print logstr("DELETE_EMPTY_VMAP", "$page_id-$vmap_id");
                }
                catch {
                    my ($e) = @_;
                    print logstr("FAIL_DELETE_VMAP", $page_id, $vmap_id, $e->message);
                };
            }
        }
    }

    if (my @pages = keys %pages) {
        $app->all_pages->mark_pages_for_async_update(page_ids => \@pages);
        print logstr("MARK_TO_RESEND", scalar(@pages));
    } else {
        print logstr("NO_TO_RESEND");
    }
}

1;
