package Utils::Oneshots::RevokeRoles;

use qbit;

sub revoke_roles {
    my ($app, $opts) = @_;

    my $users = $app->users->get_all(
        fields => ['id', 'login'],
        filter => [login => 'IN' => $opts->{logins_list}],
    );
    for my $user (@$users) {
        revoke_for_login($app, $user, $opts);
    }

}

sub revoke_for_login {
    my ($app, $user, $opts) = @_;

    my $roles = $opts->{roles_list};
    my $pages_to_delete =
      $app->users->_get_owner_pages_based_on_roles($user, $roles, multistate => 'not (deleted or protected)');

    my @skip_revoke;
    foreach my $page_accessor (keys %$pages_to_delete) {
        my $pa = $app->$page_accessor;
        my @pages;
        for my $page (@{$pages_to_delete->{$page_accessor}}) {
            if ($opts->{commit}) {
                try {
                    $pa->maybe_do_action($page, 'stop_testing');
                    $pa->maybe_do_action($page, 'stop', 'suppress_mail_notification' => TRUE);
                    $pa->maybe_do_action($page, 'delete', 'suppress_mail_notification' => TRUE);
                    push @pages, $page->{page_id};
                    print logstr("DELETE_PAGE", $user->{login}, $page_accessor, $page->{page_id});
                }
                catch {
                    my ($e) = @_;
                    print logstr("DELETE_FAIL", $user->{login}, $page_accessor, $page, $e->message);
                    push @skip_revoke, $page->{page_id};
                };
            } else {
                print logstr("DELETE_SKIP", $user->{login}, $page_accessor, $page->{page_id});
            }
        }
    }

    unless (@skip_revoke) {
        try {
            $app->users->do_action($user->{id}, 'revoke_roles', roles_id => $roles) if $opts->{commit};
            print logstr("REVOKE_ROLE", $user->{login}, $roles);
        }
        catch {
            my ($e) = @_;
            print logstr("REVOKE_FAIL", $user->{login}, $roles, $e->message);
        };
    } else {
        print logstr("REVOKE_SKIP", $user->{login}, $roles, \@skip_revoke);
    }
}

1;
