package Utils::Oneshots::UpdateContentTemplate;

use qbit;
use Utils::PublicID;

my $ISGM             = 'ISGM';
my $NOTGM            = 'NOTGM';
my $NA               = 'NA';
my $BLOCK_NOT_FOUND  = 'BLOCK_NOT_FOUND';
my $STRING_NOT_FOUND = 'STRING_NOT_FOUND';
my $BLOCK_DELETED    = 'BLOCK_DELETED';
my $BLOCK_PROTECTED  = 'BLOCK_PROTECTED';
my $ALREADY_UPDATED  = 'ALREADY_UPDATED';

sub _change_template {
    # принимаем аргумент по ссылке и возвращаем скалярный контекст
    return scalar $_[0] =~ s/<ya-unit-image\b/<ya-unit-image disable-video /g;
}

sub _check_template {
    return scalar $_[0] =~ /<ya-unit-image\b[^>]*\bdisable-video\b/;
}

sub update_content_template {
    my ($app, $opts) = @_;

    $opts->{by_prefix} = Utils::PublicID::get_block_accessors_by_public_id_prefixes($app);
    my %pages;
    for my $block (@{$opts->{blocks}}) {
        try {
            my ($page_id, $gm, $result, $extra) = process_block($app, $block, $opts);
            if ($result) {
                $pages{$page_id} = undef;
                print logstr("OK_UPDATE", $block, $gm, $extra);
            } else {
                print logstr("SKIP_UPDATE", $block, $gm, $extra);
            }
        }
        catch {
            my ($e) = @_;
            print logstr("ERROR_UPDATE", $block, $e->message);
        };
    }

    if (my @pages = sort {$a <=> $b} keys %pages) {
        $app->all_pages->mark_pages_for_async_update(page_ids => \@pages);
        print logstr("MARK_TO_RESEND", scalar(@pages));
    } else {
        print logstr("NO_TO_RESEND");
    }
}

sub process_block {
    my ($app, $block, $opts) = @_;

    my $pb        = split_block_public_id($block);
    my $accessors = $opts->{by_prefix}{$pb->{prefix}};
    for my $accessor (@$accessors) {
        my $model = $app->$accessor;
        if ($model->DOES('Application::Model::Role::Has::Block::DesignTemplates')) {
            if (
                my $row = $model->get(
                    $block,
                    fields =>
                      ['public_id', 'design_templates', 'is_custom_bk_data', 'bk_data', 'is_deleted', 'is_protected']
                )
               )
            {
                if ($row->{is_deleted}) {
                    return ($pb->{page_id}, $NA, FALSE, $BLOCK_DELETED);
                } elsif ($row->{is_protected}) {
                    return ($pb->{page_id}, $NA, FALSE, $BLOCK_PROTECTED);
                } elsif ($row->{is_custom_bk_data}) {
                    return ($pb->{page_id}, $ISGM, update_designs_gm($model, $row));
                } else {
                    return ($pb->{page_id}, $NOTGM, update_designs($model, $row));
                }
            }
        } else {
            if (
                my $row = $model->get(
                    $block,
                    fields => ['public_id', 'template', 'is_custom_bk_data', 'bk_data', 'is_deleted', 'is_protected']
                )
               )
            {
                if ($row->{is_deleted}) {
                    return ($pb->{page_id}, $NA, FALSE, $BLOCK_DELETED);
                } elsif ($row->{is_protected}) {
                    return ($pb->{page_id}, $NA, FALSE, $BLOCK_PROTECTED);
                } elsif ($row->{is_custom_bk_data}) {
                    return ($pb->{page_id}, $ISGM, update_block_gm($model, $row));
                } else {
                    return ($pb->{page_id}, $NOTGM, update_block($model, $row));
                }
            }
        }
    }
    return ($pb->{page_id}, $NA, FALSE, $BLOCK_NOT_FOUND);
}

sub update_designs {
    my ($model, $row) = @_;
    my @result;
    for my $design (@{$row->{design_templates}}) {
        if ($design->{type} && $design->{type} eq 'native') {
            my $orig_template = $design->{design_settings}{template};
            if (_check_template($orig_template)) {
                return (FALSE, $ALREADY_UPDATED);
            } elsif (my $count = _change_template($design->{design_settings}{template})) {
                push @result, {count => $count, template => $orig_template, design_id => $design->{id}};
            }
        }
    }

    if (@result) {
        $model->do_action($row->{public_id}, 'edit', design_templates => $row->{design_templates});
        return (TRUE, \@result);
    } else {
        return (FALSE, $STRING_NOT_FOUND);
    }
}

sub update_designs_gm {
    my ($model, $row) = @_;

    my $bk_data = from_json($row->{bk_data});

    my $designs = $bk_data->{$model->design_field};
    my @result;
    for my $design_id (keys %$designs) {
        if ($designs->{$design_id}{type} && $designs->{$design_id}{type} eq 'native') {
            my $orig_template = $designs->{$design_id}{design}{template};
            if (_check_template($orig_template)) {
                return (FALSE, $ALREADY_UPDATED);
            } elsif (my $count = _change_template($designs->{$design_id}{design}{template})) {
                push @result, {count => $count, template => $orig_template, design_id => $design_id};
            }
        }
    }

    if (@result) {
        $model->do_action($row->{public_id}, 'edit', bk_data => to_json($bk_data, pretty => TRUE));
        return (TRUE, \@result);
    } else {
        return (FALSE, $STRING_NOT_FOUND);
    }
    return (FALSE, $NA);
}

sub update_block {
    my ($model, $row) = @_;

    my $orig_template = $row->{template};
    if (_check_template($orig_template)) {
        return (FALSE, $ALREADY_UPDATED);
    } elsif (my $count = _change_template($row->{template})) {
        $model->do_action($row->{public_id}, 'edit', template => $row->{template});
        return (TRUE, {count => $count, template => $orig_template});
    } else {
        return (FALSE, $STRING_NOT_FOUND);
    }
}

sub update_block_gm {
    my ($model, $row) = @_;

    my $bk_data       = from_json($row->{bk_data});
    my $orig_template = $bk_data->{CustomBlockData}{WidgetInfo}{Template};
    if (_check_template($orig_template)) {
        return (FALSE, $ALREADY_UPDATED);
    } elsif (my $count = _change_template($bk_data->{CustomBlockData}{WidgetInfo}{Template})) {
        $model->do_action($row->{public_id}, 'edit', bk_data => to_json($bk_data, pretty => TRUE));
        return (TRUE, {count => $count, template => $orig_template});
    } else {
        return (FALSE, $STRING_NOT_FOUND);
    }
}

1;
