package Utils::Oneshots::UpdateStoredBKReports;

use qbit;

my %MAP = (
    'rtb_block_shows'               => 'shows',
    'rtb_block_hits_own_adv'        => 'hits_own',
    'rtb_block_hits_unsold'         => 'hits_unsold',
    'rtb_block_hits'                => 'hits_render',
    'rtb_block_shows_own_adv'       => 'shows_own',
    'rtb_block_all_hits'            => 'hits',
    'rtb_block_direct_shows'        => 'shows_direct',
    'rtb_block_direct_clicks'       => 'clicks_direct',
    'rtb_block_direct_ctr'          => 'ctr_direct',
    'rtb_block_visibility'          => 'visibility',
    'rtb_block_cover_ratio'         => 'fillrate',
    'rtb_block_winrate'             => 'winrate',
    'rtb_block_rpm_all_wo_nds'      => 'rpm_all_wo_nds',
    'rtb_block_cpmh_partner_wo_nds' => 'ecpm_partner_wo_nds',
    'rtb_block_rpm_partner_wo_nds'  => 'rpm_partner_wo_nds',
    'rtb_block_cpmh_all_wo_nds'     => 'ecpm_all_wo_nds',
    'rtb_block_cpm_all_wo_nds'      => 'cpmv_all_wo_nds',
    'rtb_block_cpm_partner_wo_nds'  => 'cpmv_partner_wo_nds',
    'rtb_all_wo_nds'                => 'all_wo_nds',
    'rtb_partner_wo_nds'            => 'partner_wo_nds',
);

my $PART_SIZE = 1000;

sub get_part {
    my ($app, $last_key) = @_;

    my @filter;
    if ($last_key) {
        push @filter, [{concat => ['update_date', 'id']} => '>' => \$last_key];
    }

    my $list = $app->partner_db->stat_report_params_digest->get_all(
        fields => [qw(id update_date params)],
        filter => [AND => [[params => 'LIKE' => \'%offset%'], @filter]],
        order_by => ['update_date', 'id'],
        limit    => $PART_SIZE,
    );

    return $list && @$list ? $list : undef;
}

sub update_reports {
    my ($app, $opts) = @_;

    my $last_key;
    my $count = 0;
    while (my $list = get_part($app, $last_key)) {
        for my $row (@$list) {
            $last_key = $row->{update_date} . $row->{id};
            try {
                if (my $new_params = update_params(from_json($row->{params}))) {
                    $app->partner_db->stat_report_params_digest->edit($row->{id}, {params => to_json($new_params)});
                    $count++;
                    print logstr("UPDATE_OK", $row->{update_date}, $row->{id}, $row->{params}, $new_params);
                }
            }
            catch {
                my ($e) = @_;
                print logstr("UPDATE_FAIL", $row->{update_date}, $row->{id}, $row->{params}, $e->message);
            };
        }
    }

    print logstr("UPDATED", $count);
}

sub update_params {
    my ($params) = @_;

    my $has_change;
    for my $tab (qw(tableLevel chartLevel)) {
        for my $sec (qw(fields)) {
            if (my $v = $params->{$tab} && $params->{$tab}[0] && $params->{$tab}[0]{$sec}) {
                my @f;
                for my $f (@$v) {
                    if (exists $MAP{$f}) {
                        push @f, $MAP{$f};
                        $has_change = TRUE;
                    } else {
                        push @f, $f;
                    }
                }
                $params->{$tab}[0]{$sec} = \@f;
            }
        }

        for my $sec (qw(top_keys_order_by)) {
            if (my $v = $params->{$tab} && $params->{$tab}[0] && $params->{$tab}[0]{$sec}) {
                my @f;
                for my $e (@$v) {
                    if (exists $MAP{$e->{field}}) {
                        $e->{field} = $MAP{$e->{field}};
                    }
                }
            }
        }
    }

    return $has_change ? $params : undef;
}

1;
