package Utils::Oneshots::UserFeature;

use qbit;

sub add_feature_to_all_users {
    my ($app, $opts) = @_;

    my $FEATURE_NAME = $opts->{'feature'};

    if ($FEATURE_NAME) {
        my @user_id_list = map {$_->{id}} @{
            $app->partner_db->_get_all(
                qq(select users.id from users
    left join user_features on (user_features.user_id = users.id and feature = '$FEATURE_NAME') where user_features.id is null)
            )
          };

        my $user_list = $app->users->get_all(
            fields => [qw(id login features)],
            filter => ['id' => 'IN' => \@user_id_list]
        );

        for my $user (@$user_list) {
            try {
                $app->users->do_action($user->{id}, 'edit', features => [(@{$user->{features} // []}, $FEATURE_NAME)]);
                print logstr($user->{login} . ' - ok');
            }
            catch {
                my ($ex) = @_;
                print logstr($user->{login} . '-', $ex->message);
            };
        }
    } else {
        print logstr("please pass --feature param, got $FEATURE_NAME");
    }
}

1;
