package Utils::Order;

use qbit;

our @ISA    = qw(Exporter);
our @EXPORT = qw(
  get_sort_function
  );

use Exception::IncorrectParams;

sub get_sort_function {
    my ($order_by, %opts) = @_;

    throw Exception::IncorrectParams '"order_by" has wrong format. Expected not empty array'
      if ref($order_by) ne 'ARRAY' || !@$order_by;

    my $row_is_hash  = $opts{'row_is_hash'};
    my $column_names = $opts{'column_names'};

    my $map_field_names = {};
    unless ($row_is_hash) {
        throw Exception::IncorrectParams 'Option "column_names" is required'
          unless defined($column_names);

        my $index = 0;
        map {$map_field_names->{$_} = $index++} @$column_names;
    }

    my $code = "sub {\n    no warnings;\n    return ";

    my $item_placeholder = $row_is_hash ? '{%s}' : '[%s]';

    my @body = ();
    foreach my $sort (@$order_by) {
        my $name = $sort->{'name'} // throw Exception::IncorrectParams 'Expected key "name" in "order_by" items';

        my $key = $row_is_hash ? $name : $map_field_names->{$name}
          // throw Exception::IncorrectParams sprintf('For field "%s" not exists mapping', $name);
        my $item = sprintf($item_placeholder, $key);

        my $opr = defined($sort->{'type'}) && $sort->{'type'} eq 'number' ? '<=>' : 'cmp';

        my $items_index = defined($sort->{'sort_order'}) && $sort->{'sort_order'} eq 'desc' ? [1, 0] : [0, 1];

        push(@body, sprintf('$_[%d]->%s %s $_[%d]->%s', $items_index->[0], $item, $opr, $items_index->[1], $item));
    }

    $code .= join(' || ', @body) . ";\n}";

    my $ref_sub = eval($code);

    throw $@ if $@;

    return $ref_sub;
}

TRUE;
