package Utils::Safe;

use Term::ANSIColor qw(colored);

use qbit;
use PiConstants qw($DB_CONFIG_FILE_PATH $MYSQL_PRODUCTION_USER);

use base qw(Exporter);

our @EXPORT = qw(confirm_connect_on_production fail_connect_on_production);

my $IS_DB_PRODUCTION;

sub confirm_connect_on_production {

    my $env = lc($ENV{ENVIRONMENT} || '');
    if (_need_confirm_connect()) {
        my $prompt = "Are you sure you want to work with PRODUCTION base (yes/no)?";
        if (-t STDOUT) {
            print colored($prompt, 'red');
        } else {
            print $prompt;
        }
        my $answer = <STDIN> // '';
        chomp $answer;
        exit 0 unless lc($answer) eq 'yes';
        $ENV{ENVIRONMENT} = 'production';
    }
}

sub fail_connect_on_production {

    if (_need_confirm_connect()) {
        $ENV{'IS_THROW_ON_ACTION_FOR_PROD'} = TRUE;
    }
}

sub _need_confirm_connect {

    my $env = lc($ENV{ENVIRONMENT} || '');

    return $env ne 'production' && _is_db_production();
}

sub _is_db_production {

    $IS_DB_PRODUCTION //= eval {
        # на этапе сборки образа файл отсутствует, поэтому eval
        _get_config_json_data($DB_CONFIG_FILE_PATH)->{partnerdb2}->{user} eq $MYSQL_PRODUCTION_USER;
    } ? TRUE : FALSE;
}

sub _get_config_json_data {
    my ($config_path) = @_;
    my $content       = readfile($config_path);
    my $json          = from_json($content);
    return $json;
}

1;
