
=encoding UTF-8

=head1 DESCRIPTION

=cut

package Utils::Stream::DataSource::Array;

use base qw(Utils::Stream::DataSource);

use qbit;

sub init {
    my ($self) = @_;

    throw "Expected 'ARRAY' reference" if ref($self->{source}) ne 'ARRAY';

    $self->{_index_} = 0;

    return;
}

sub has_next {
    my ($self) = @_;
    return $self->{_index_} < @{$self->{source}};
}

sub next {
    my ($self) = @_;
    return unless $self->has_next();
    return $self->{source}[$self->{_index_}++];
}

sub get_bulk {
    my ($self, $n) = @_;

    return [] unless $n > 0 and $self->has_next();

    my $left  = $self->{_index_};
    my $right = $left + $n;

    $right = @{$self->{source}} if $right > @{$self->{source}};
    --$right;

    my $bulk = [@{$self->{source}}[$left .. $right]];

    $self->{_index_} = $right + 1;

    return $bulk;
}

1;
