
=encoding UTF-8

=head1 DESCRIPTION

=cut

package Utils::Stream::DataSource::DBStatement;

use base qw(Utils::Stream::DataSource);

use qbit;
use Exception;

sub init {
    my ($self) = @_;

    # throw "Expected 'Statement'" if self->{source} is not Statement;

    $self->_fetch();
    return;
}

sub has_next {
    my ($self) = @_;

    return FALSE unless exists($self->{_buffer_});
    return TRUE if defined($self->{_buffer_});

    $self->_fetch();

    return defined($self->{_buffer_});
}

sub next {
    my ($self) = @_;
    return unless $self->has_next();

    my $next = $self->{_buffer_};
    $self->{_buffer_} = undef;
    return $next;
}

sub _fetch {
    my ($self) = @_;

    $self->{_buffer_} = $self->{source}->fetchrow_hashref();
    delete($self->{_buffer_}) unless defined($self->{_buffer_});

    return if defined($self->{_buffer_});

    my $err_code = $self->{source}->err();
    if ($err_code and $self->{_on_error_}) {
        $self->{_on_error_}->(Exception->new($err_code));
    }
    return;
}

sub get_bulk {
    my ($self, $n) = @_;

    my @bulk;

    # if we have something in buffer
    if ($n > 0 and $self->{_buffer_}) {
        push @bulk, $self->{_buffer_};
        $self->{_buffer_} = undef;
        --$n;
    }

    while ($n > 0 and (my $row = $self->{source}->fetchrow_hashref())) {
        push @bulk, $row;
        --$n;
    }

    if ($n > 0) {
        delete($self->{_buffer_});
        my $err_code = $self->{source}->err();
        $self->{_on_error_}->(Exception->new($err_code)) if $err_code and $self->{_on_error_};
    }

    return \@bulk;
}

1;
