package Utils::Stream::DataSource::FileHandler;

use base qw(Utils::Stream::DataSource);

use qbit;
use Exception;

sub init {
    my ($self) = @_;

    $self->{_buffer_} = undef;
    return;
}

sub has_next {
    my ($self) = @_;

    return FALSE unless exists($self->{_buffer_});
    return TRUE if defined($self->{_buffer_});

    my $fh = $self->{source};
    if (defined(my $buffer = <$fh>)) {
        $self->{_buffer_} = $buffer;
    } else {
        delete $self->{_buffer_};
    }

    return exists $self->{_buffer_};
}

sub next {
    my ($self) = @_;

    return unless $self->has_next();

    my $next = $self->{_buffer_};
    $self->{_buffer_} = undef;
    return $next;
}

sub get_bulk {
    my ($self, $n) = @_;

    my @bulk;

    # if we have something in buffer
    if ($n > 0 and $self->{_buffer_}) {
        push @bulk, $self->{_buffer_};
        $self->{_buffer_} = undef;
        --$n;
    }

    my $fh = $self->{source};
    while ($n > 0 and defined(my $row = <$fh>)) {
        push @bulk, $row;
        --$n;
    }

    if ($n > 0) {
        delete($self->{_buffer_});
    }

    return \@bulk;
}

1;
