
=encoding UTF-8

=head1 DESCRIPTION

=cut

package Utils::Stream::DataSource::Map;

use base qw(Utils::Stream::DataSource);

use qbit;

sub init {
    my ($self) = @_;

    throw "Expected 'DataSource' object"
      unless blessed($self->{source})
          and $self->{source}->isa('Utils::Stream::DataSource');

    throw "Expected 'CODE' reference" if ref($self->{map}) ne 'CODE';

    $self->{_error_occured_} = FALSE;

    return;
}

sub has_next {
    my ($self) = @_;
    return $self->{_error_occured_} ? FALSE : $self->{source}->has_next();
}

sub next {
    my ($self) = @_;

    return if $self->{_error_occured_};

    my $next = $self->{source}->next();

    try {
        $next = $self->{map}->($next);
    }
    catch {
        $self->{_error_occured_} = TRUE;
        $self->{_on_error_}->(shift) if $self->{_on_error_};
    };

    return if $self->{_error_occured_};

    return $next;
}

sub get_bulk {
    my ($self, $n) = @_;

    return [] unless $n > 0 and not $self->{_error_occured_};

    my $bulk = $self->{source}->get_bulk($n);

    try {
        $_ = $self->{map}->($_) for @$bulk;
    }
    catch {
        $self->{_error_occured_} = TRUE;
        $self->{_on_error_}->(shift) if $self->{_on_error_};
    };

    return $bulk;
}

sub on_error {
    my ($self, $callback) = @_;
    $self->{_on_error_} = $callback;
    $self->{source}->on_error($callback);
    return;
}

1;
