
=encoding UTF-8

=head1 DESCRIPTION

=cut

package Utils::Stream::DataSource::Query;

use base qw(Utils::Stream::DataSource::DBStatement);

use qbit;
use Exception::DB;

sub init {
    my ($self) = @_;

    my $query = $self->{source};

    throw "Expected 'Query' object" unless blessed($query) and $query->isa('QBit::Application::Model::DB::Query');

    my $dbh = $query->db->get_dbh();

    my ($sql) = $query->get_sql_with_data();

    my $sth = $dbh->prepare($sql) or do {
        my $err_code = $dbh->err();
        throw Exception::DB $dbh->errstr() . " ($err_code)\n" . $sql, errorcode => $err_code;
    };

    $sth->execute() or do {
        my $err_code = $sth->err();
        throw Exception::DB $sth->errstr() . " ($err_code)\n" . $sql, errorcode => $err_code;
    };
    $self->{source} = $sth;

    $self->SUPER::init();
    return;
}

1;
