package Utils::Stream::Writer::Buffer;

use base qw(Utils::Stream::Writer);

use qbit;

sub init {
    my ($self) = @_;
    $self->clear();
    return;
}

sub clear {
    my ($self) = @_;
    $self->{_buffer_} = [];
    return;
}

sub write {
    my ($self, $str) = @_;
    throw 'Argument must be an scalar value' if ref $str;
    push @{$self->{_buffer_}}, $str;
}

sub content {
    my ($self) = @_;
    return join('', @{$self->{_buffer_}});
}

1;
