package Utils::Stream::Writer::OutStream;

use base qw(Utils::Stream::Writer);

use qbit;

sub init {
    my ($self) = @_;

    throw sprintf('Param "output" must be a GLOB, but got "%s"', ref($self->{output}))
      if ref($self->{output}) ne 'GLOB';

    if ($self->{'encode'}) {
        $self->{'handler'} = \&unset_utf;
    } else {
        $self->{'handler'} = \&fix_utf;
    }

    return;
}

sub flush {
    my ($self) = @_;
    $self->{output}->flush();
    return;
}

sub write {
    my ($self, $str) = @_;
    #throw 'Argument must be an scalar value' if ref $str;
    print {$self->{output}} $self->{'handler'}->($str);
}

1;
