package Utils::Swagger;

use PiConstants qw( $SWAGGER_PATH );

use qbit;

use File::Basename qw(dirname);
use File::Find qw(find);
use File::Path qw(make_path);
use File::Slurp;

sub get_swagger_json {

    my $content = File::Slurp::read_file($SWAGGER_PATH, {binmode => ':utf8'});

    my $json = from_json($content);

    return $json;
}

sub compose_swagger_json {

    my $dst_path = dirname($SWAGGER_PATH);

    my @paths = ();
    find(
        sub {
            push @paths, $File::Find::name if $File::Find::name =~ /\.json$/;
        },
        $dst_path
    );

    my $container = undef;

    foreach my $path (sort @paths) {
        next if $path eq $SWAGGER_PATH;

        my $content = File::Slurp::read_file($path, {binmode => ':utf8'});
        my $json = from_json($content);

        # prettify source
        File::Slurp::write_file($path, {binmode => ':utf8'}, to_json($json, pretty => 1));

        unless ($container) {
            $container = clone($json);
            $container->{paths} = {};
        }

        map {$container->{paths}->{$_} = $json->{paths}->{$_}} keys %{$json->{paths}};
    }

    File::Slurp::write_file($SWAGGER_PATH, {binmode => ':utf8'}, to_json($container, pretty => 1));

    print "$SWAGGER_PATH - ready\n";

}

sub split_swagger_json {

    my $json = get_swagger_json();

    my $container = clone($json);
    $container->{paths} = {};

    my $found_paths = {};
    foreach my $path (keys %{$json->{paths}}) {
        my ($prefix) = ($path =~ m|^/?([^/]+)|);
        $found_paths->{$prefix}->{$path} = $json->{paths}->{$path};
    }

    my $dst_path = dirname($SWAGGER_PATH);

    foreach my $prefix (keys %$found_paths) {
        make_path("$dst_path/$prefix");

        my $file_data = clone($container);
        $file_data->{paths} = $found_paths->{$prefix};

        my $file_path = "$dst_path/$prefix/swagger.json";

        File::Slurp::write_file($file_path, {binmode => ':utf8'}, to_json($file_data, pretty => 1),);

        print "$file_path - ok\n";
    }
}

sub update_swagger_json {
    my ($app) = @_;

    my $dst_path = dirname($SWAGGER_PATH);
    my @paths    = ();
    find(
        sub {
            push @paths, $File::Find::name if $File::Find::name =~ /\.json$/;
        },
        $dst_path
    );

    foreach my $path (sort @paths) {
        next if $path eq $SWAGGER_PATH;

        my $content = File::Slurp::read_file($path, {binmode => ':utf8'});
        my $json = from_json($content);

        foreach my $path (keys %{$json->{paths}}) {
            if ($path =~ m!^/(?<model>\w+)(?<id>/\{id\})?$!) {
                my $model = $+{model};
                my $value = $json->{paths}{$path};
                my $id    = $+{id};

                if (exists($value->{get})) {
                    foreach my $param (@{$value->{get}{parameters}}) {
                        if (exists($param->{items})) {
                            if ($param->{name} =~ '^fields\[') {
                                my @api_fields = $app->$model->api_available_fields();
                                $param->{items}{enum} = \@api_fields;
                                print "$path - $param->{name} - api_available_fields\n";
                            } elsif ($param->{name} =~ 'filter') {
                                my @existing_filters;

                                my $filter = $app->$model->get_model_filter_fields();
                                my @get_examples_from_base;
                                my %api_fields = map {$_ => TRUE} $app->$model->api_available_fields();
                                foreach (sort grep {$api_fields{$_}} keys %$filter) {
                                    my $type = $filter->{$_}{type};
                                    if ($type eq 'boolean') {
                                        push @existing_filters, sprintf('["%s", "=", false]', $_);
                                        push @existing_filters, sprintf('["%s", "=", true]',  $_);
                                    } elsif ($type eq 'number'
                                        || $type eq 'text'
                                        || $type eq 'date'
                                        || $type eq 'publicid')
                                    {
                                        my $string;
                                        if ($_ eq 'login') {
                                            $string = 'qwerty';
                                        } elsif ($_ eq 'name') {
                                            $string = 'Иван';
                                        } elsif ($_ eq 'lastname') {
                                            $string = 'Иванов';
                                        } elsif ($_ eq 'email') {
                                            $string = 'ivanov@yandex.ru';
                                        } elsif ($_ eq 'data_key') {
                                            $string = '4rkfekcffvhie9jbfu1kfkq0if2cfff';
                                        } elsif ($_ eq 'phone') {
                                            push @existing_filters, sprintf('["%s", "=", "+79451534825"]',       $_);
                                            push @existing_filters, sprintf('["%s", "=", "+7 (234) 930-16-45"]', $_);
                                            next;
                                        } else {
                                            push @get_examples_from_base, $_;
                                        }

                                        push @existing_filters, sprintf('["%s", "=", "%s"]', $_, $string)
                                          if $string;
                                    }
                                }

                                if (@get_examples_from_base) {
                                    my %example = %{
                                        $app->$model->get_all(
                                            fields   => \@get_examples_from_base,
                                            limit    => 1,
                                            order_by => ['id']
                                          )->[0]
                                      };
                                    foreach (keys %example) {
                                        push @existing_filters,
                                          sprintf('["%s", "=", "%s"]',
                                            $_,
                                            (ref($example{$_}) eq 'ARRAY' ? $example{$_}->[0] : $example{$_})
                                              // 'null');
                                    }
                                }

                                my @multistates = sort keys %{$app->$model->get_multistate_names()};
                                foreach (@multistates) {
                                    $_ = sprintf('["multistate", "=", "%s"]', $_);
                                }
                                push @existing_filters, @multistates;
                                $param->{items}{enum} = \@existing_filters;
                                print "$path - $param->{name} - filters update\n";
                            }
                        }
                    }
                }
            }
        }

        File::Slurp::write_file($path, {binmode => ':utf8'}, to_json($json, pretty => 1));
    }
}

1;
