package Utils::Tree;

use Tree::Simple;

our @ISA    = qw(Exporter);
our @EXPORT = qw(
  get_tree_by_array
  get_array_by_tree
  );

use qbit;

sub get_array_by_tree {
    my ($tree) = @_;

    my @result = ();

    $tree->traverse(
        sub {
            my ($element) = @_;

            push(@result, $element->getNodeValue());
        }
    );

    return \@result;
}

sub get_tree_by_array {
    my ($data, %opts) = @_;

    my $id_key_name        = delete($opts{'id_key_name'})        // 'id';
    my $parent_id_key_name = delete($opts{'parent_id_key_name'}) // 'parent_id';

    my $tree = Tree::Simple->new({}, Tree::Simple->ROOT);

    my $cache = {};

    my @no_found_parent = ();
    while (my $elem = shift(@$data)) {
        $cache->{$elem->{$id_key_name}}->{'id'} = $elem->{$id_key_name};

        $cache->{$elem->{$id_key_name}}->{'parent_id'} = $elem->{$parent_id_key_name};

        $cache->{$elem->{$id_key_name}}->{'elem'} = Tree::Simple->new($elem);

        unless (defined($elem->{$parent_id_key_name})) {
            $tree->addChild($cache->{$elem->{$id_key_name}}->{'elem'});

            next;
        }

        $cache->{$elem->{$parent_id_key_name}}->{$elem->{$id_key_name}} = $cache->{$elem->{$id_key_name}};

        if (exists($cache->{$elem->{$parent_id_key_name}}->{'elem'})) {
            $cache->{$elem->{$parent_id_key_name}}->{'elem'}->addChild($cache->{$elem->{$id_key_name}}->{'elem'});
        } else {
            push(@no_found_parent, $elem->{$id_key_name});
        }
    }

    foreach (@no_found_parent) {
        $cache->{$cache->{$_}->{'parent_id'}}->{'elem'}->addChild($cache->{$_}->{'elem'});
    }

    return $tree;
}

TRUE;
