package Utils::UniqueID;

our @ISA    = qw(Exporter);
our @EXPORT = qw(
  make_unique_id
  split_unique_id
  list_to_bits
  bits_to_list
  );

use qbit;

use Exception::Validation::BadArguments;

use PiConstants qw(%UNIQUE_ID_PREFIX);

my %MODEL_BY_PREFIX = reverse %UNIQUE_ID_PREFIX;

# Ключ состоит из 63 битов:
# старшие 8 битов: префикс модели Диапазон значений: 0..255
# следующие 32 бита: page_id Диапазон значений: 0..4_294_967_295
# следующие 23 бита: block_id Диапазон значений: 0..8_388_607
my $BIT_SHIFTS = [8, 32, 23];

sub make_unique_id {
    my ($prefix, $page_id, $block_id) = @_;

    unless (defined($MODEL_BY_PREFIX{$prefix})) {
        $prefix = $UNIQUE_ID_PREFIX{$prefix}
          // throw Exception::Validation::BadArguments gettext("Can't find prefix '%s'", $prefix);
    }

    return list_to_bits([$prefix, $page_id, $block_id], $BIT_SHIFTS);
}

sub split_unique_id {
    my ($unique_id) = @_;
    return bits_to_list($unique_id, $BIT_SHIFTS);
}

sub list_to_bits {
    my ($list, $bitc) = @_;
    my $out    = 0;
    my $lshift = 0;
    for (my $i = @$list - 1; $i > -1; $i--) {
        $out |= ($list->[$i] << $lshift);
        $lshift += $bitc->[$i];
    }
    return $out;
}

sub bits_to_list {
    my ($in, $bitc) = @_;
    my @out;
    my $rshift = 0;
    for my $bc (reverse @$bitc) {
        push @out, ($in >> $rshift) & ~(~0 >> $bc << $bc);
        $rshift += $bc;
    }
    return [reverse @out];
}

TRUE;
